/*
 * Decompiled with CFR 0.152.
 */
package com.platform.api;

import com.platform.annotation.IgnoreAuth;
import com.platform.cache.RegionCacheUtil;
import com.platform.entity.RegionVo;
import com.platform.entity.SysRegionEntity;
import com.platform.util.ApiBaseAction;
import com.platform.utils.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8bc4\u8bba"})
@RestController
@RequestMapping(value={"/api/region"})
public class ApiRegionController
extends ApiBaseAction {
    @ApiOperation(value="\u5730\u533a\u5217\u8868")
    @IgnoreAuth
    @PostMapping(value={"list"})
    public Object list(Integer parentId) {
        List regionEntityList = RegionCacheUtil.getChildrenByParentId((Integer)parentId);
        ArrayList<RegionVo> regionVoList = new ArrayList<RegionVo>();
        if (null != regionEntityList && regionEntityList.size() > 0) {
            for (SysRegionEntity sysRegionEntity : regionEntityList) {
                regionVoList.add(new RegionVo(sysRegionEntity));
            }
        }
        return this.toResponsSuccess(regionVoList);
    }

    @IgnoreAuth
    @PostMapping(value={"provinceList"})
    public Object provinceList() {
        List regionEntityList = RegionCacheUtil.getAllProvice();
        ArrayList<RegionVo> regionVoList = new ArrayList<RegionVo>();
        if (null != regionEntityList && regionEntityList.size() > 0) {
            for (SysRegionEntity sysRegionEntity : regionEntityList) {
                regionVoList.add(new RegionVo(sysRegionEntity));
            }
        }
        return this.toResponsSuccess(regionVoList);
    }

    @IgnoreAuth
    @PostMapping(value={"cityList"})
    public Object provinceList(String proviceName) {
        List regionEntityList = RegionCacheUtil.getChildrenCity((String)proviceName);
        ArrayList<RegionVo> regionVoList = new ArrayList<RegionVo>();
        if (null != regionEntityList && regionEntityList.size() > 0) {
            for (SysRegionEntity sysRegionEntity : regionEntityList) {
                regionVoList.add(new RegionVo(sysRegionEntity));
            }
        }
        return this.toResponsSuccess(regionVoList);
    }

    @IgnoreAuth
    @PostMapping(value={"distinctList"})
    public Object distinctList(String proviceName, String cityName) {
        List regionEntityList = RegionCacheUtil.getChildrenDistrict((String)proviceName, (String)cityName);
        ArrayList<RegionVo> regionVoList = new ArrayList<RegionVo>();
        if (null != regionEntityList && regionEntityList.size() > 0) {
            for (SysRegionEntity sysRegionEntity : regionEntityList) {
                regionVoList.add(new RegionVo(sysRegionEntity));
            }
        }
        return this.toResponsSuccess(regionVoList);
    }

    @IgnoreAuth
    @PostMapping(value={"info"})
    public Object info(Integer regionId) {
        SysRegionEntity regionEntity = RegionCacheUtil.getAreaByAreaId((Integer)regionId);
        return this.toResponsSuccess(new RegionVo(regionEntity));
    }

    @IgnoreAuth
    @PostMapping(value={"regionIdsByNames"})
    public Object regionIdsByNames(String provinceName, String cityName, String districtName) {
        HashMap<String, Integer> resultObj = new HashMap<String, Integer>();
        Integer provinceId = 0;
        Integer cityId = 0;
        Integer districtId = 0;
        if (null != provinceName) {
            provinceId = RegionCacheUtil.getProvinceIdByName((String)provinceName);
        }
        if (null != provinceId && !StringUtils.isNullOrEmpty((Object)cityName)) {
            cityId = RegionCacheUtil.getCityIdByName((Integer)provinceId, (String)cityName);
        }
        if (null != provinceId && null != cityId && !StringUtils.isNullOrEmpty((Object)districtName)) {
            districtId = RegionCacheUtil.getDistrictIdByName((Integer)provinceId, (Integer)cityId, (String)districtName);
        }
        resultObj.put("provinceId", provinceId);
        resultObj.put("cityId", cityId);
        resultObj.put("districtId", districtId);
        return this.toResponsSuccess(resultObj);
    }
}

