/*
 * Decompiled with CFR 0.152.
 */
package com.platform.api;

import com.platform.annotation.IgnoreAuth;
import com.platform.annotation.LoginUser;
import com.platform.cache.J2CacheUtils;
import com.platform.entity.OrderGoodsVo;
import com.platform.entity.OrderVo;
import com.platform.entity.ProductVo;
import com.platform.entity.UserVo;
import com.platform.service.ApiOrderGoodsService;
import com.platform.service.ApiOrderService;
import com.platform.service.ApiProductService;
import com.platform.util.ApiBaseAction;
import com.platform.util.wechat.WechatRefundApiResult;
import com.platform.util.wechat.WechatUtil;
import com.platform.utils.CharUtil;
import com.platform.utils.DateUtils;
import com.platform.utils.MapUtils;
import com.platform.utils.ResourceUtil;
import com.platform.utils.XmlUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u5546\u6237\u652f\u4ed8"})
@RestController
@RequestMapping(value={"/api/pay"})
public class ApiPayController
extends ApiBaseAction {
    private static final Logger log = LoggerFactory.getLogger(ApiPayController.class);
    private org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(this.getClass());
    @Autowired
    private ApiOrderService orderService;
    @Autowired
    private ApiOrderGoodsService orderGoodsService;
    @Autowired
    private ApiProductService productService;

    @ApiOperation(value="\u8df3\u8f6c")
    @PostMapping(value={"index"})
    public Object index() {
        return this.toResponsSuccess("");
    }

    @ApiOperation(value="\u83b7\u53d6\u652f\u4ed8\u7684\u8bf7\u6c42\u53c2\u6570")
    @PostMapping(value={"prepay"})
    public Object payPrepay(@LoginUser UserVo loginUser, Integer orderId) {
        OrderVo orderInfo = this.orderService.queryObject(orderId);
        if (null == orderInfo) {
            return this.toResponsObject(400, "\u8ba2\u5355\u5df2\u53d6\u6d88", "");
        }
        if (orderInfo.getPay_status() != 0 && orderInfo.getPay_status() != 1) {
            return this.toResponsObject(400, "\u8ba2\u5355\u5df2\u652f\u4ed8\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c", "");
        }
        String nonceStr = CharUtil.getRandomString((Integer)32);
        TreeMap<Object, Object> resultObj = new TreeMap<Object, Object>();
        try {
            TreeMap<Object, Object> parame = new TreeMap<Object, Object>();
            parame.put("appid", ResourceUtil.getConfigByName((String)"wx.appId"));
            parame.put("mch_id", ResourceUtil.getConfigByName((String)"wx.mchId"));
            String randomStr = CharUtil.getRandomNum((Integer)18).toUpperCase();
            parame.put("nonce_str", randomStr);
            parame.put("out_trade_no", orderInfo.getOrder_sn());
            this.logger.info((Object)("out_trade_no:" + orderInfo.getOrder_sn()));
            HashMap<String, Object> orderGoodsParam = new HashMap<String, Object>();
            orderGoodsParam.put("order_id", orderId);
            parame.put("body", "\u7535\u5546-\u652f\u4ed8");
            List<OrderGoodsVo> orderGoods = this.orderGoodsService.queryList(orderGoodsParam);
            if (null != orderGoods) {
                String body = "\u8d85\u5e02-";
                parame.put("body", orderInfo.getOrder_sn());
            }
            parame.put("total_fee", orderInfo.getActual_price().multiply(new BigDecimal(100)).intValue());
            parame.put("notify_url", ResourceUtil.getConfigByName((String)"wx.notifyUrl"));
            parame.put("trade_type", ResourceUtil.getConfigByName((String)"wx.tradeType"));
            parame.put("spbill_create_ip", this.getClientIp());
            parame.put("openid", loginUser.getWeixin_openid());
            String sign = WechatUtil.arraySign(parame, ResourceUtil.getConfigByName((String)"wx.paySignKey"));
            parame.put("sign", sign);
            String xml = MapUtils.convertMap2Xml(parame);
            this.logger.info((Object)("xml:" + xml));
            Map resultUn = XmlUtil.xmlStrToMap((String)WechatUtil.requestOnce(ResourceUtil.getConfigByName((String)"wx.uniformorder"), xml));
            String return_code = MapUtils.getString((String)"return_code", (Map)resultUn);
            String return_msg = MapUtils.getString((String)"return_msg", (Map)resultUn);
            if (return_code.equalsIgnoreCase("FAIL")) {
                return this.toResponsFail("\u652f\u4ed8\u5931\u8d25," + return_msg);
            }
            if (return_code.equalsIgnoreCase("SUCCESS")) {
                String result_code = MapUtils.getString((String)"result_code", (Map)resultUn);
                String err_code_des = MapUtils.getString((String)"err_code_des", (Map)resultUn);
                if (result_code.equalsIgnoreCase("FAIL")) {
                    return this.toResponsFail("\u652f\u4ed8\u5931\u8d25," + err_code_des);
                }
                if (result_code.equalsIgnoreCase("SUCCESS")) {
                    String prepay_id = MapUtils.getString((String)"prepay_id", (Map)resultUn);
                    resultObj.put("appId", ResourceUtil.getConfigByName((String)"wx.appId"));
                    resultObj.put("timeStamp", DateUtils.timeToStr((Long)(System.currentTimeMillis() / 1000L), (String)"yyyy-MM-dd HH:mm:ss"));
                    resultObj.put("nonceStr", nonceStr);
                    resultObj.put("package", "prepay_id=" + prepay_id);
                    resultObj.put("signType", "MD5");
                    String paySign = WechatUtil.arraySign(resultObj, ResourceUtil.getConfigByName((String)"wx.paySignKey"));
                    resultObj.put("paySign", paySign);
                    orderInfo.setPay_id(prepay_id);
                    orderInfo.setPay_status(0);
                    this.orderService.update(orderInfo);
                    return this.toResponsObject(0, "\u5fae\u4fe1\u7edf\u4e00\u8ba2\u5355\u4e0b\u5355\u6210\u529f", resultObj);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.toResponsFail("\u4e0b\u5355\u5931\u8d25,error=" + e.getMessage());
        }
        return this.toResponsFail("\u4e0b\u5355\u5931\u8d25");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiOperation(value="\u67e5\u8be2\u8ba2\u5355\u72b6\u6001")
    @PostMapping(value={"query"})
    public Object orderQuery(@LoginUser UserVo loginUser, Integer orderId) {
        if (orderId == null) {
            return this.toResponsFail("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        OrderVo orderDetail = this.orderService.queryObject(orderId);
        TreeMap<Object, Object> parame = new TreeMap<Object, Object>();
        parame.put("appid", ResourceUtil.getConfigByName((String)"wx.appId"));
        parame.put("mch_id", ResourceUtil.getConfigByName((String)"wx.mchId"));
        String randomStr = CharUtil.getRandomNum((Integer)18).toUpperCase();
        parame.put("nonce_str", randomStr);
        parame.put("out_trade_no", orderDetail.getOrder_sn());
        String sign = WechatUtil.arraySign(parame, ResourceUtil.getConfigByName((String)"wx.paySignKey"));
        parame.put("sign", sign);
        String xml = MapUtils.convertMap2Xml(parame);
        this.logger.info((Object)("xml:" + xml));
        Map resultUn = null;
        try {
            resultUn = XmlUtil.xmlStrToMap((String)WechatUtil.requestOnce(ResourceUtil.getConfigByName((String)"wx.orderquery"), xml));
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.toResponsFail("\u67e5\u8be2\u5931\u8d25,error=" + e.getMessage());
        }
        String return_code = MapUtils.getString((String)"return_code", (Map)resultUn);
        String return_msg = MapUtils.getString((String)"return_msg", (Map)resultUn);
        if (!"SUCCESS".equals(return_code)) {
            return this.toResponsFail("\u67e5\u8be2\u5931\u8d25,error=" + return_msg);
        }
        String trade_state = MapUtils.getString((String)"trade_state", (Map)resultUn);
        if ("SUCCESS".equals(trade_state)) {
            OrderVo orderInfo = new OrderVo();
            orderInfo.setId(orderId);
            orderInfo.setPay_status(2);
            orderInfo.setOrder_status(201);
            orderInfo.setShipping_status(0);
            orderInfo.setPay_time(new Date());
            this.orderService.update(orderInfo);
            HashMap<String, Object> orderGoodsParam = new HashMap<String, Object>();
            orderGoodsParam.put("order_id", orderInfo.getId());
            List<OrderGoodsVo> goodsList = this.orderGoodsService.queryList(orderGoodsParam);
            if (goodsList == null || goodsList.size() <= 0) return this.toResponsMsgSuccess("\u652f\u4ed8\u6210\u529f");
            this.logger.info((Object)("goodsList: " + goodsList.size()));
            HashMap<String, Object> productGoodsParam = new HashMap<String, Object>();
            productGoodsParam.put("goods_id", goodsList.get(0).getGoods_id());
            List<ProductVo> productList = this.productService.queryList(productGoodsParam);
            if (productList == null || productList.size() <= 0) return this.toResponsMsgSuccess("\u652f\u4ed8\u6210\u529f");
            this.logger.info((Object)("productList: " + productList.size()));
            ProductVo productVo = productList.get(0);
            productVo.setGoods_number(productVo.getGoods_number() - goodsList.get(0).getNumber());
            this.productService.update(productVo);
            return this.toResponsMsgSuccess("\u652f\u4ed8\u6210\u529f");
        }
        if (!"USERPAYING".equals(trade_state)) return this.toResponsFail("\u67e5\u8be2\u5931\u8d25,error=" + trade_state);
        Integer num = (Integer)J2CacheUtils.get((String)J2CacheUtils.SHOP_CACHE_NAME, (String)("queryRepeatNum" + orderId + ""));
        if (num == null) {
            J2CacheUtils.put((String)J2CacheUtils.SHOP_CACHE_NAME, (String)("queryRepeatNum" + orderId + ""), (Object)1);
            this.orderQuery(loginUser, orderId);
            return this.toResponsFail("\u67e5\u8be2\u5931\u8d25\uff0c\u672a\u77e5\u9519\u8bef");
        } else {
            if (num > 3) return this.toResponsFail("\u67e5\u8be2\u5931\u8d25,error=" + trade_state);
            J2CacheUtils.remove((String)J2CacheUtils.SHOP_CACHE_NAME, (String)("queryRepeatNum" + orderId));
            this.orderQuery(loginUser, orderId);
        }
        return this.toResponsFail("\u67e5\u8be2\u5931\u8d25\uff0c\u672a\u77e5\u9519\u8bef");
    }

    @ApiIgnore
    @IgnoreAuth
    @RequestMapping(value={"/notify"}, method={RequestMethod.POST}, produces={"text/html;charset=UTF-8"})
    public void notify(HttpServletRequest request, HttpServletResponse response) {
        try {
            request.setCharacterEncoding("UTF-8");
            response.setCharacterEncoding("UTF-8");
            response.setContentType("text/html;charset=UTF-8");
            response.setHeader("Access-Control-Allow-Origin", "*");
            ServletInputStream in = request.getInputStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            out.close();
            in.close();
            String reponseXml = new String(out.toByteArray(), "utf-8");
            this.logger.info((Object)("notify:" + reponseXml));
            WechatRefundApiResult result = (WechatRefundApiResult)XmlUtil.xmlStrToBean((String)reponseXml, WechatRefundApiResult.class);
            String result_code = result.getResult_code();
            if (result_code.equalsIgnoreCase("FAIL")) {
                String out_trade_no = result.getOut_trade_no();
                this.logger.info((Object)("\u8ba2\u5355" + out_trade_no + "\u652f\u4ed8\u5931\u8d25"));
                response.getWriter().write(ApiPayController.setXml("SUCCESS", "OK"));
            } else if (result_code.equalsIgnoreCase("SUCCESS")) {
                String out_trade_no = result.getOut_trade_no();
                this.logger.info((Object)("\u8ba2\u5355" + out_trade_no + "\u652f\u4ed8\u6210\u529f"));
                OrderVo orderInfo = this.orderService.queryObjectByOrderSn(out_trade_no);
                orderInfo.setPay_status(2);
                orderInfo.setOrder_status(201);
                orderInfo.setShipping_status(0);
                orderInfo.setPay_time(new Date());
                this.orderService.update(orderInfo);
                response.getWriter().write(ApiPayController.setXml("SUCCESS", "OK"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    @ApiOperation(value="\u8ba2\u5355\u9000\u6b3e\u8bf7\u6c42")
    @PostMapping(value={"refund"})
    public Object refund(Integer orderId) {
        OrderVo orderInfo = this.orderService.queryObject(orderId);
        if (null == orderInfo) {
            return this.toResponsObject(400, "\u8ba2\u5355\u5df2\u53d6\u6d88", "");
        }
        if (orderInfo.getOrder_status() == 401 || orderInfo.getOrder_status() == 402) {
            return this.toResponsObject(400, "\u8ba2\u5355\u5df2\u9000\u6b3e", "");
        }
        WechatRefundApiResult result = WechatUtil.wxRefund(orderInfo.getId().toString(), orderInfo.getActual_price().doubleValue(), orderInfo.getActual_price().doubleValue());
        if (result.getResult_code().equals("SUCCESS")) {
            if (orderInfo.getOrder_status() == 201) {
                orderInfo.setOrder_status(401);
            } else if (orderInfo.getOrder_status() == 300) {
                orderInfo.setOrder_status(402);
            }
            this.orderService.update(orderInfo);
            return this.toResponsObject(400, "\u6210\u529f\u9000\u6b3e", "");
        }
        return this.toResponsObject(400, "\u9000\u6b3e\u5931\u8d25", "");
    }

    public static String setXml(String return_code, String return_msg) {
        return "<xml><return_code><![CDATA[" + return_code + "]]></return_code><return_msg><![CDATA[" + return_msg + "]]></return_msg></xml>";
    }

    public static String callbakcXml(String orderNum) {
        return "<xml><appid><![CDATA[wx2421b1c4370ec43b]]></appid><attach><![CDATA[\u652f\u4ed8\u6d4b\u8bd5]]></attach><bank_type><![CDATA[CFT]]></bank_type><fee_type><![CDATA[CNY]]></fee_type> <is_subscribe><![CDATA[Y]]></is_subscribe><mch_id><![CDATA[10000100]]></mch_id><nonce_str><![CDATA[5d2b6c2a8db53831f7eda20af46e531c]]></nonce_str><openid><![CDATA[oUpF8uMEb4qRXf22hE3X68TekukE]]></openid> <out_trade_no><![CDATA[" + orderNum + "]]></out_trade_no>  <result_code><![CDATA[SUCCESS]]></result_code> <return_code><![CDATA[SUCCESS]]></return_code><sign><![CDATA[B552ED6B279343CB493C5DD0D78AB241]]></sign><sub_mch_id><![CDATA[10000100]]></sub_mch_id> <time_end><![CDATA[20140903131540]]></time_end><total_fee>1</total_fee><trade_type><![CDATA[JSAPI]]></trade_type><transaction_id><![CDATA[1004400740201409030005092168]]></transaction_id></xml>";
    }
}

