/*
 * Decompiled with CFR 0.152.
 */
package com.platform.api;

import com.platform.annotation.IgnoreAuth;
import com.platform.annotation.LoginUser;
import com.platform.entity.GoodsVo;
import com.platform.entity.OrderGoodsVo;
import com.platform.entity.OrderShippingVo;
import com.platform.entity.OrderVo;
import com.platform.entity.UserVo;
import com.platform.service.ApiBrandService;
import com.platform.service.ApiGoodsService;
import com.platform.service.ApiKdniaoService;
import com.platform.service.ApiOrderGoodsService;
import com.platform.service.ApiOrderService;
import com.platform.service.ApiOrderShippingService;
import com.platform.util.ApiBaseAction;
import com.platform.util.ApiPageUtils;
import com.platform.util.wechat.WechatRefundApiResult;
import com.platform.util.wechat.WechatUtil;
import com.platform.utils.Query;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8ba2\u5355\u76f8\u5173"})
@RestController
@RequestMapping(value={"/api/order"})
public class ApiOrderController
extends ApiBaseAction {
    @Autowired
    private ApiOrderService orderService;
    @Autowired
    private ApiOrderGoodsService orderGoodsService;
    @Autowired
    private ApiKdniaoService apiKdniaoService;
    @Autowired
    private ApiOrderShippingService apiOrderShippingService;
    @Autowired
    private ApiGoodsService apiGoodsService;
    @Autowired
    private ApiBrandService apiBrandService;

    @ApiOperation(value="\u8ba2\u5355\u9996\u9875")
    @IgnoreAuth
    @PostMapping(value={"index"})
    public Object index() {
        return this.toResponsSuccess("");
    }

    @ApiOperation(value="\u83b7\u53d6\u8ba2\u5355\u5217\u8868")
    @PostMapping(value={"list"})
    public Object list(@LoginUser UserVo loginUser, @RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="orderStatus", defaultValue="-1") Integer orderStatus) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("user_id", loginUser.getUserId());
        params.put("page", page);
        params.put("limit", size);
        params.put("sidx", "id");
        params.put("order", "desc");
        if (orderStatus >= 0) {
            params.put("order_status", orderStatus);
        }
        Query query = new Query(params);
        List<OrderVo> orderEntityList = this.orderService.queryList((Map<String, Object>)query);
        int total = this.orderService.queryTotal((Map<String, Object>)query);
        ApiPageUtils pageUtil = new ApiPageUtils(orderEntityList, total, query.getLimit(), query.getPage());
        for (OrderVo item : orderEntityList) {
            HashMap<String, Object> orderGoodsParam = new HashMap<String, Object>();
            orderGoodsParam.put("order_id", item.getId());
            List<OrderGoodsVo> goodsList = this.orderGoodsService.queryList(orderGoodsParam);
            item.setGoodsList(goodsList);
            Integer goodsCount = 0;
            for (OrderGoodsVo orderGoodsEntity : goodsList) {
                goodsCount = goodsCount + orderGoodsEntity.getNumber();
                item.setGoodsCount(goodsCount);
            }
        }
        return this.toResponsSuccess(pageUtil);
    }

    @ApiOperation(value="\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5")
    @PostMapping(value={"detail"})
    public Object detail(Integer orderId) {
        HashMap<String, Object> resultObj = new HashMap<String, Object>();
        OrderVo orderInfo = this.orderService.queryObject(orderId);
        if (null == orderInfo) {
            return this.toResponsObject(400, "\u8ba2\u5355\u4e0d\u5b58\u5728", "");
        }
        HashMap<String, Object> orderGoodsParam = new HashMap<String, Object>();
        orderGoodsParam.put("order_id", orderId);
        orderGoodsParam.put("orderId", orderId);
        List<OrderShippingVo> shippingVoList = this.apiOrderShippingService.queryList(orderGoodsParam);
        List<OrderGoodsVo> orderGoods = this.orderGoodsService.queryList(orderGoodsParam);
        GoodsVo goodsVo = null;
        for (OrderGoodsVo orderGoodsVo : orderGoods) {
            goodsVo = this.apiGoodsService.queryObject(orderGoodsVo.getGoods_id());
            this.logger.info((Object)("goodsVo:" + goodsVo.getBrand_id()));
            for (OrderShippingVo orderShippingVo : shippingVoList) {
                this.logger.info((Object)("orderShippingVo:" + orderShippingVo.getBrandId()));
                List<Object> orderGoodsVoList = new ArrayList<OrderGoodsVo>();
                if (goodsVo.getBrand_id().intValue() != orderShippingVo.getBrandId().intValue()) continue;
                if (orderShippingVo.getOrderGoodsVoList() == null) {
                    orderGoodsVoList.add(orderGoodsVo);
                    orderShippingVo.setOrderGoodsVoList(orderGoodsVoList);
                    continue;
                }
                orderGoodsVoList = orderShippingVo.getOrderGoodsVoList();
                orderGoodsVoList.add(orderGoodsVo);
                orderShippingVo.setOrderGoodsVoList(orderGoodsVoList);
            }
        }
        if (orderInfo.getOrder_status() == 0) {
            // empty if block
        }
        for (OrderShippingVo orderShippingVo : shippingVoList) {
            orderShippingVo.setBrandName(this.apiBrandService.queryObject(orderShippingVo.getBrandId()).getName());
        }
        Map handleOption = orderInfo.getHandleOption();
        resultObj.put("orderInfo", orderInfo);
        resultObj.put("orderGoods", shippingVoList);
        resultObj.put("handleOption", handleOption);
        if (!StringUtils.isEmpty((String)orderInfo.getShipping_code()) && !StringUtils.isEmpty((String)orderInfo.getShipping_no())) {
            List Traces = this.apiKdniaoService.getOrderTracesByJson(orderInfo.getShipping_code(), orderInfo.getShipping_no());
            resultObj.put("shippingList", Traces);
        }
        return this.toResponsSuccess(resultObj);
    }

    @ApiOperation(value="\u4fee\u6539\u8ba2\u5355")
    @PostMapping(value={"updateSuccess"})
    public Object updateSuccess(Integer orderId) {
        OrderVo orderInfo = this.orderService.queryObject(orderId);
        if (orderInfo == null) {
            return this.toResponsFail("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (orderInfo.getOrder_status() != 0) {
            return this.toResponsFail("\u8ba2\u5355\u72b6\u6001\u4e0d\u6b63\u786eorderStatus" + orderInfo.getOrder_status() + "payStatus" + orderInfo.getPay_status());
        }
        orderInfo.setId(orderId);
        orderInfo.setPay_status(2);
        orderInfo.setOrder_status(201);
        orderInfo.setShipping_status(0);
        orderInfo.setPay_time(new Date());
        int num = this.orderService.update(orderInfo);
        if (num > 0) {
            return this.toResponsMsgSuccess("\u4fee\u6539\u8ba2\u5355\u6210\u529f");
        }
        return this.toResponsFail("\u4fee\u6539\u8ba2\u5355\u5931\u8d25");
    }

    @ApiOperation(value="\u8ba2\u5355\u63d0\u4ea4")
    @PostMapping(value={"submit"})
    public Object submit(@LoginUser UserVo loginUser) {
        Map<String, Object> resultObj = null;
        try {
            resultObj = this.orderService.submit(this.getJsonRequest(), loginUser);
            if (null != resultObj) {
                return this.toResponsObject(MapUtils.getInteger(resultObj, (Object)"errno"), MapUtils.getString(resultObj, (Object)"errmsg"), resultObj.get("data"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.toResponsFail("\u63d0\u4ea4\u5931\u8d25");
    }

    @ApiOperation(value="\u53d6\u6d88\u8ba2\u5355")
    @PostMapping(value={"cancelOrder"})
    public Object cancelOrder(Integer orderId) {
        try {
            OrderVo orderVo = this.orderService.queryObject(orderId);
            if (orderVo.getOrder_status() == 300) {
                return this.toResponsFail("\u5df2\u53d1\u8d27\uff0c\u4e0d\u80fd\u53d6\u6d88");
            }
            if (orderVo.getOrder_status() == 301) {
                return this.toResponsFail("\u5df2\u6536\u8d27\uff0c\u4e0d\u80fd\u53d6\u6d88");
            }
            if (orderVo.getPay_status() == 2) {
                WechatRefundApiResult result = WechatUtil.wxRefund(orderVo.getOrder_sn(), orderVo.getActual_price().doubleValue(), orderVo.getActual_price().doubleValue());
                if (result.getResult_code().equals("SUCCESS")) {
                    if (orderVo.getOrder_status() == 201) {
                        orderVo.setOrder_status(401);
                    } else if (orderVo.getOrder_status() == 300) {
                        orderVo.setOrder_status(402);
                    }
                    orderVo.setPay_status(4);
                    this.orderService.update(orderVo);
                    return this.toResponsMsgSuccess("\u53d6\u6d88\u6210\u529f");
                }
                return this.toResponsObject(400, "\u53d6\u6d88\u6210\u5931\u8d25", "");
            }
            orderVo.setOrder_status(102);
            this.orderService.update(orderVo);
            return this.toResponsMsgSuccess("\u53d6\u6d88\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.toResponsFail("\u63d0\u4ea4\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u786e\u8ba4\u6536\u8d27")
    @PostMapping(value={"confirmOrder"})
    public Object confirmOrder(Integer orderId) {
        try {
            OrderVo orderVo = this.orderService.queryObject(orderId);
            orderVo.setOrder_status(301);
            orderVo.setShipping_status(2);
            orderVo.setConfirm_time(new Date());
            this.orderService.update(orderVo);
            return this.toResponsSuccess("\u786e\u8ba4\u6536\u8d27\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.toResponsFail("\u63d0\u4ea4\u5931\u8d25");
        }
    }
}

