/*
 * Decompiled with CFR 0.152.
 */
package com.platform.api;

import com.github.pagehelper.PageHelper;
import com.platform.annotation.IgnoreAuth;
import com.platform.entity.AdVo;
import com.platform.entity.BrandVo;
import com.platform.entity.CartVo;
import com.platform.entity.CategoryVo;
import com.platform.entity.ChannelVo;
import com.platform.entity.GoodsVo;
import com.platform.entity.TopicVo;
import com.platform.service.ApiAdService;
import com.platform.service.ApiBrandService;
import com.platform.service.ApiCartService;
import com.platform.service.ApiCategoryService;
import com.platform.service.ApiChannelService;
import com.platform.service.ApiGoodsService;
import com.platform.service.ApiTopicService;
import com.platform.util.ApiBaseAction;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9996\u9875\u63a5\u53e3\u6587\u6863"})
@RestController
@RequestMapping(value={"/api/index"})
public class ApiIndexController
extends ApiBaseAction {
    @Autowired
    private ApiAdService adService;
    @Autowired
    private ApiChannelService channelService;
    @Autowired
    private ApiGoodsService goodsService;
    @Autowired
    private ApiBrandService brandService;
    @Autowired
    private ApiTopicService topicService;
    @Autowired
    private ApiCategoryService categoryService;
    @Autowired
    private ApiCartService cartService;

    @IgnoreAuth
    @PostMapping(value={"test"})
    public Object test() {
        return this.toResponsMsgSuccess("\u8bf7\u6c42\u6210\u529fyyy");
    }

    @ApiOperation(value="\u9996\u9875")
    @IgnoreAuth
    @PostMapping(value={"index"})
    public Object index() {
        HashMap<String, List<Serializable>> resultObj = new HashMap<String, List<Serializable>>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("ad_position_id", 1);
        List<AdVo> banner = this.adService.queryList(param);
        resultObj.put("banner", banner);
        param = new HashMap();
        param.put("sidx", "sort_order ");
        param.put("order", "asc ");
        List<ChannelVo> channel = this.channelService.queryList(param);
        resultObj.put("channel", channel);
        param = new HashMap();
        param.put("is_new", 1);
        param.put("is_delete", 0);
        param.put("fields", "id, name, list_pic_url, retail_price");
        PageHelper.startPage((int)0, (int)4, (boolean)false);
        List<GoodsVo> newGoods = this.goodsService.queryList(param);
        resultObj.put("newGoodsList", newGoods);
        param = new HashMap();
        param.put("is_hot", "1");
        param.put("is_delete", 0);
        PageHelper.startPage((int)0, (int)3, (boolean)false);
        List<GoodsVo> hotGoods = this.goodsService.queryHotGoodsList(param);
        resultObj.put("hotGoodsList", hotGoods);
        List<Object> cartList = new ArrayList();
        if (null != this.getUserId()) {
            HashMap<String, Object> cartParam = new HashMap<String, Object>();
            cartParam.put("user_id", this.getUserId());
            cartList = this.cartService.queryList(cartParam);
        }
        if (null != cartList && cartList.size() > 0 && null != hotGoods && hotGoods.size() > 0) {
            for (GoodsVo goodsVo : hotGoods) {
                for (CartVo cartVo : cartList) {
                    if (!goodsVo.getId().equals(cartVo.getGoods_id())) continue;
                    goodsVo.setCart_num(cartVo.getNumber());
                }
            }
        }
        param = new HashMap();
        param.put("is_new", 1);
        param.put("sidx", "new_sort_order ");
        param.put("order", "asc ");
        param.put("offset", 0);
        param.put("limit", 4);
        List<BrandVo> brandList = this.brandService.queryList(param);
        resultObj.put("brandList", brandList);
        param = new HashMap();
        param.put("offset", 0);
        param.put("limit", 3);
        List<TopicVo> topicList = this.topicService.queryList(param);
        resultObj.put("topicList", topicList);
        param = new HashMap();
        param.put("parent_id", 0);
        param.put("notName", "\u63a8\u8350");
        List<CategoryVo> categoryList = this.categoryService.queryList(param);
        ArrayList arrayList = new ArrayList();
        for (CategoryVo categoryItem : categoryList) {
            param.remove("fields");
            param.put("parent_id", categoryItem.getId());
            List<CategoryVo> categoryEntityList = this.categoryService.queryList(param);
            ArrayList<Integer> childCategoryIds = new ArrayList<Integer>();
            for (CategoryVo categoryEntity : categoryEntityList) {
                childCategoryIds.add(categoryEntity.getId());
            }
            param = new HashMap();
            param.put("categoryIds", childCategoryIds);
            param.put("fields", "id as id, name as name, list_pic_url as list_pic_url, retail_price as retail_price");
            PageHelper.startPage((int)0, (int)7, (boolean)false);
            List<GoodsVo> categoryGoods = this.goodsService.queryList(param);
            HashMap<String, Object> newCategory = new HashMap<String, Object>();
            newCategory.put("id", categoryItem.getId());
            newCategory.put("name", categoryItem.getName());
            newCategory.put("goodsList", categoryGoods);
            arrayList.add(newCategory);
        }
        resultObj.put("categoryList", arrayList);
        return this.toResponsSuccess(resultObj);
    }

    @ApiOperation(value="\u65b0\u5546\u54c1\u4fe1\u606f")
    @IgnoreAuth
    @PostMapping(value={"newGoods"})
    public Object newGoods() {
        HashMap<String, List<GoodsVo>> resultObj = new HashMap<String, List<GoodsVo>>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("is_new", 1);
        param.put("is_delete", 0);
        param.put("fields", "id, name, list_pic_url, retail_price");
        PageHelper.startPage((int)0, (int)4, (boolean)false);
        List<GoodsVo> newGoods = this.goodsService.queryList(param);
        resultObj.put("newGoodsList", newGoods);
        return this.toResponsSuccess(resultObj);
    }

    @ApiOperation(value="\u65b0\u70ed\u95e8\u5546\u54c1\u4fe1\u606f")
    @IgnoreAuth
    @PostMapping(value={"hotGoods"})
    public Object hotGoods() {
        HashMap<String, List<GoodsVo>> resultObj = new HashMap<String, List<GoodsVo>>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("is_hot", "1");
        param.put("is_delete", 0);
        PageHelper.startPage((int)0, (int)3, (boolean)false);
        List<GoodsVo> hotGoods = this.goodsService.queryHotGoodsList(param);
        resultObj.put("hotGoodsList", hotGoods);
        return this.toResponsSuccess(resultObj);
    }

    @ApiOperation(value="topic")
    @IgnoreAuth
    @PostMapping(value={"topic"})
    public Object topic() {
        HashMap<String, List<TopicVo>> resultObj = new HashMap<String, List<TopicVo>>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("offset", 0);
        param.put("limit", 3);
        List<TopicVo> topicList = this.topicService.queryList(param);
        resultObj.put("topicList", topicList);
        return this.toResponsSuccess(resultObj);
    }

    @ApiOperation(value="brand")
    @IgnoreAuth
    @PostMapping(value={"brand"})
    public Object brand() {
        HashMap<String, List<BrandVo>> resultObj = new HashMap<String, List<BrandVo>>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("is_new", 1);
        param.put("sidx", "new_sort_order ");
        param.put("order", "asc ");
        param.put("offset", 0);
        param.put("limit", 4);
        List<BrandVo> brandList = this.brandService.queryList(param);
        resultObj.put("brandList", brandList);
        return this.toResponsSuccess(resultObj);
    }

    @ApiOperation(value="category")
    @IgnoreAuth
    @PostMapping(value={"category"})
    public Object category() {
        HashMap resultObj = new HashMap();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param = new HashMap();
        param.put("parent_id", 0);
        param.put("notName", "\u63a8\u8350");
        List<CategoryVo> categoryList = this.categoryService.queryList(param);
        ArrayList newCategoryList = new ArrayList();
        for (CategoryVo categoryItem : categoryList) {
            param.remove("fields");
            param.put("parent_id", categoryItem.getId());
            List<CategoryVo> categoryEntityList = this.categoryService.queryList(param);
            ArrayList<Integer> childCategoryIds = null;
            if (categoryEntityList != null && categoryEntityList.size() > 0) {
                childCategoryIds = new ArrayList<Integer>();
                for (CategoryVo categoryEntity : categoryEntityList) {
                    childCategoryIds.add(categoryEntity.getId());
                }
            }
            param = new HashMap();
            param.put("categoryIds", childCategoryIds);
            param.put("fields", "id as id, name as name, list_pic_url as list_pic_url, retail_price as retail_price");
            param.put("is_delete", "0");
            PageHelper.startPage((int)0, (int)7, (boolean)false);
            List<GoodsVo> categoryGoods = this.goodsService.queryList(param);
            HashMap<String, Object> newCategory = new HashMap<String, Object>();
            newCategory.put("id", categoryItem.getId());
            newCategory.put("name", categoryItem.getName());
            newCategory.put("goodsList", categoryGoods);
            newCategoryList.add(newCategory);
        }
        resultObj.put("categoryList", newCategoryList);
        return this.toResponsSuccess(resultObj);
    }

    @ApiOperation(value="banner")
    @IgnoreAuth
    @PostMapping(value={"banner"})
    public Object banner() {
        HashMap<String, List<AdVo>> resultObj = new HashMap<String, List<AdVo>>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("ad_position_id", 1);
        List<AdVo> banner = this.adService.queryList(param);
        resultObj.put("banner", banner);
        return this.toResponsSuccess(resultObj);
    }

    @ApiOperation(value="channel")
    @IgnoreAuth
    @PostMapping(value={"channel"})
    public Object channel() {
        HashMap<String, List<ChannelVo>> resultObj = new HashMap<String, List<ChannelVo>>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param = new HashMap();
        param.put("sidx", "sort_order ");
        param.put("order", "asc ");
        List<ChannelVo> channel = this.channelService.queryList(param);
        resultObj.put("channel", channel);
        return this.toResponsSuccess(resultObj);
    }
}

