/*
 * Decompiled with CFR 0.152.
 */
package com.platform.api;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.platform.annotation.IgnoreAuth;
import com.platform.annotation.LoginUser;
import com.platform.entity.AttributeVo;
import com.platform.entity.BrandVo;
import com.platform.entity.CartVo;
import com.platform.entity.CategoryVo;
import com.platform.entity.CommentPictureVo;
import com.platform.entity.CommentVo;
import com.platform.entity.CouponVo;
import com.platform.entity.FootprintVo;
import com.platform.entity.GoodsGalleryVo;
import com.platform.entity.GoodsIssueVo;
import com.platform.entity.GoodsSpecificationVo;
import com.platform.entity.GoodsVo;
import com.platform.entity.ProductVo;
import com.platform.entity.RelatedGoodsVo;
import com.platform.entity.SearchHistoryVo;
import com.platform.entity.TokenEntity;
import com.platform.entity.UserCouponVo;
import com.platform.entity.UserVo;
import com.platform.service.ApiAttributeService;
import com.platform.service.ApiBrandService;
import com.platform.service.ApiCartService;
import com.platform.service.ApiCategoryService;
import com.platform.service.ApiCollectService;
import com.platform.service.ApiCommentPictureService;
import com.platform.service.ApiCommentService;
import com.platform.service.ApiCouponService;
import com.platform.service.ApiFootprintService;
import com.platform.service.ApiGoodsGalleryService;
import com.platform.service.ApiGoodsIssueService;
import com.platform.service.ApiGoodsService;
import com.platform.service.ApiGoodsSpecificationService;
import com.platform.service.ApiProductService;
import com.platform.service.ApiRelatedGoodsService;
import com.platform.service.ApiSearchHistoryService;
import com.platform.service.ApiUserCouponService;
import com.platform.service.ApiUserService;
import com.platform.util.ApiBaseAction;
import com.platform.util.ApiPageUtils;
import com.platform.utils.Base64Util;
import com.platform.utils.CharUtil;
import com.platform.utils.DateUtils;
import com.platform.utils.Query;
import com.qiniu.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5546\u54c1\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/goods"})
public class ApiGoodsController
extends ApiBaseAction {
    @Autowired
    private ApiGoodsService goodsService;
    @Autowired
    private ApiGoodsSpecificationService goodsSpecificationService;
    @Autowired
    private ApiProductService productService;
    @Autowired
    private ApiGoodsGalleryService goodsGalleryService;
    @Autowired
    private ApiGoodsIssueService goodsIssueService;
    @Autowired
    private ApiAttributeService attributeService;
    @Autowired
    private ApiBrandService brandService;
    @Autowired
    private ApiCommentService commentService;
    @Autowired
    private ApiUserService userService;
    @Autowired
    private ApiCommentPictureService commentPictureService;
    @Autowired
    private ApiCollectService collectService;
    @Autowired
    private ApiFootprintService footprintService;
    @Autowired
    private ApiCategoryService categoryService;
    @Autowired
    private ApiSearchHistoryService searchHistoryService;
    @Autowired
    private ApiRelatedGoodsService relatedGoodsService;
    @Autowired
    private ApiCouponService apiCouponService;
    @Autowired
    private ApiUserCouponService apiUserCouponService;
    @Autowired
    private ApiCartService cartService;

    @ApiOperation(value="\u5546\u54c1\u9996\u9875")
    @IgnoreAuth
    @PostMapping(value={"index"})
    public Object index() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("is_delete", 0);
        param.put("is_on_sale", 1);
        List<GoodsVo> goodsList = this.goodsService.queryList(param);
        return this.toResponsSuccess(goodsList);
    }

    @ApiOperation(value=" \u83b7\u53d6\u5546\u54c1\u89c4\u683c\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5546\u54c1id", paramType="path", required=true)})
    @IgnoreAuth
    @PostMapping(value={"sku"})
    public Object sku(Integer id) {
        HashMap<String, List<Serializable>> resultObj = new HashMap<String, List<Serializable>>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("goods_id", id);
        List<GoodsSpecificationVo> goodsSpecificationEntityList = this.goodsSpecificationService.queryList(param);
        List<ProductVo> productEntityList = this.productService.queryList(param);
        resultObj.put("specificationList", goodsSpecificationEntityList);
        resultObj.put("productList", productEntityList);
        return this.toResponsSuccess(resultObj);
    }

    @ApiOperation(value=" \u5546\u54c1\u8be6\u60c5\u9875\u6570\u636e")
    @IgnoreAuth
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5546\u54c1id", paramType="path", required=true), @ApiImplicitParam(name="referrer", value="\u5546\u54c1referrer", paramType="path", required=false)})
    @PostMapping(value={"detail"})
    public Object detail(Integer id, Long referrer) {
        HashMap<String, Object> resultObj = new HashMap<String, Object>();
        Long userId = this.getUserId();
        GoodsVo info = this.goodsService.queryObject(id);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("goods_id", id);
        HashMap<String, Object> specificationParam = new HashMap<String, Object>();
        specificationParam.put("fields", "gs.*, s.name");
        specificationParam.put("goods_id", id);
        specificationParam.put("specification", true);
        specificationParam.put("sidx", "s.sort_order");
        specificationParam.put("order", "asc");
        List<GoodsSpecificationVo> goodsSpecificationEntityList = this.goodsSpecificationService.queryList(specificationParam);
        ArrayList specificationList = new ArrayList();
        block2: for (int i = 0; i < goodsSpecificationEntityList.size(); ++i) {
            int j;
            GoodsSpecificationVo specItem = goodsSpecificationEntityList.get(i);
            List<GoodsSpecificationVo> tempList = null;
            for (j = 0; j < specificationList.size(); ++j) {
                if (!((Map)specificationList.get(j)).get("specification_id").equals(specItem.getSpecification_id())) continue;
                tempList = (ArrayList<GoodsSpecificationVo>)((Map)specificationList.get(j)).get("valueList");
                break;
            }
            if (null == tempList) {
                HashMap<String, Object> temp = new HashMap<String, Object>();
                temp.put("specification_id", specItem.getSpecification_id());
                temp.put("name", specItem.getName());
                tempList = new ArrayList<GoodsSpecificationVo>();
                tempList.add(specItem);
                temp.put("valueList", tempList);
                specificationList.add(temp);
                continue;
            }
            for (j = 0; j < specificationList.size(); ++j) {
                if (!((Map)specificationList.get(j)).get("specification_id").equals(specItem.getSpecification_id())) continue;
                tempList = (List)((Map)specificationList.get(j)).get("valueList");
                tempList.add(specItem);
                continue block2;
            }
        }
        List<ProductVo> productEntityList = this.productService.queryList(param);
        List<GoodsGalleryVo> gallery = this.goodsGalleryService.queryList(param);
        HashMap<String, Object> ngaParam = new HashMap<String, Object>();
        ngaParam.put("fields", "nga.value, na.name");
        ngaParam.put("sidx", "nga.id");
        ngaParam.put("order", "asc");
        ngaParam.put("goods_id", id);
        List<AttributeVo> attribute = this.attributeService.queryList(ngaParam);
        HashMap<String, Object> issueParam = new HashMap<String, Object>();
        List<GoodsIssueVo> issue = this.goodsIssueService.queryList(issueParam);
        BrandVo brand = this.brandService.queryObject(info.getBrand_id());
        param.put("value_id", id);
        param.put("type_id", 0);
        Integer commentCount = this.commentService.queryTotal(param);
        List<CommentVo> hotComment = this.commentService.queryList(param);
        HashMap<String, Object> commentInfo = new HashMap<String, Object>();
        if (null != hotComment && hotComment.size() > 0) {
            UserVo commentUser = this.userService.queryObject(hotComment.get(0).getUser_id());
            commentInfo.put("content", Base64Util.decode((String)hotComment.get(0).getContent()));
            commentInfo.put("add_time", DateUtils.timeToStr((Long)hotComment.get(0).getAdd_time(), (String)"yyyy-MM-dd"));
            commentInfo.put("nickname", commentUser.getNickname());
            commentInfo.put("avatar", commentUser.getAvatar());
            HashMap<String, Object> paramPicture = new HashMap<String, Object>();
            paramPicture.put("comment_id", hotComment.get(0).getId());
            List<CommentPictureVo> commentPictureEntities = this.commentPictureService.queryList(paramPicture);
            commentInfo.put("pic_list", commentPictureEntities);
        }
        HashMap<String, Serializable> comment = new HashMap<String, Serializable>();
        comment.put("count", commentCount);
        comment.put("data", commentInfo);
        Integer userHasCollect = 0;
        if (this.getUserId() != null) {
            HashMap<String, Object> collectParam = new HashMap<String, Object>();
            collectParam.put("user_id", this.getUserId());
            collectParam.put("value_id", id);
            collectParam.put("type_id", 0);
            userHasCollect = this.collectService.queryTotal(collectParam);
            if (userHasCollect > 0) {
                userHasCollect = 1;
            }
        }
        FootprintVo footprintEntity = new FootprintVo();
        footprintEntity.setAdd_time(System.currentTimeMillis() / 1000L);
        footprintEntity.setGoods_brief(info.getGoods_brief());
        footprintEntity.setList_pic_url(info.getList_pic_url());
        footprintEntity.setGoods_id(info.getId());
        footprintEntity.setName(info.getName());
        footprintEntity.setRetail_price(info.getRetail_price());
        footprintEntity.setUser_id(userId);
        if (null != referrer) {
            footprintEntity.setReferrer(referrer);
        } else {
            footprintEntity.setReferrer(0L);
        }
        this.footprintService.save(footprintEntity);
        resultObj.put("info", info);
        resultObj.put("gallery", gallery);
        resultObj.put("attribute", attribute);
        resultObj.put("userHasCollect", userHasCollect);
        resultObj.put("issue", issue);
        resultObj.put("comment", comment);
        resultObj.put("brand", brand);
        resultObj.put("specificationList", specificationList);
        resultObj.put("productList", productEntityList);
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("user_id", userId);
            params.put("send_type", 2);
            params.put("unUsed", true);
            List<CouponVo> enabledCouponVos = this.apiCouponService.queryUserCoupons(params);
            if ((null == enabledCouponVos || enabledCouponVos.size() == 0) && null != referrer && null != userId) {
                HashMap<String, Object> couponParam = new HashMap<String, Object>();
                couponParam.put("enabled", true);
                Integer[] send_types = new Integer[]{2};
                couponParam.put("send_types", send_types);
                List<CouponVo> couponVos = this.apiCouponService.queryList(couponParam);
                if (null != couponVos && couponVos.size() > 0) {
                    CouponVo couponVo = couponVos.get(0);
                    HashMap<String, Object> footprintParam = new HashMap<String, Object>();
                    footprintParam.put("goods_id", id);
                    footprintParam.put("referrer", referrer);
                    Integer footprintNum = this.footprintService.queryTotal(footprintParam);
                    if (null != footprintNum && null != couponVo.getMin_transmit_num() && footprintNum > couponVo.getMin_transmit_num()) {
                        UserCouponVo userCouponVo = new UserCouponVo();
                        userCouponVo.setAdd_time(new Date());
                        userCouponVo.setCoupon_id(couponVo.getId());
                        userCouponVo.setCoupon_number(CharUtil.getRandomString((Integer)12));
                        userCouponVo.setUser_id(this.getUserId());
                        this.apiUserCouponService.save(userCouponVo);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.toResponsSuccess(resultObj);
    }

    @ApiOperation(value=" \u83b7\u53d6\u5206\u7c7b\u4e0b\u7684\u5546\u54c1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5206\u7c7bid", paramType="path", required=true)})
    @IgnoreAuth
    @PostMapping(value={"category"})
    public Object category(Integer id) {
        HashMap<String, Object> resultObj = new HashMap<String, Object>();
        CategoryVo currentCategory = this.categoryService.queryObject(id);
        CategoryVo parentCategory = this.categoryService.queryObject(currentCategory.getParent_id());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("parent_id", currentCategory.getParent_id());
        List<CategoryVo> brotherCategory = this.categoryService.queryList(params);
        resultObj.put("currentCategory", currentCategory);
        resultObj.put("parentCategory", parentCategory);
        resultObj.put("brotherCategory", brotherCategory);
        return this.toResponsSuccess(resultObj);
    }

    @ApiOperation(value="\u83b7\u53d6\u5546\u54c1\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="categoryId", value="\u5206\u7c7bid", paramType="path", required=true), @ApiImplicitParam(name="brandId", value="\u54c1\u724cId", paramType="path", required=true), @ApiImplicitParam(name="isNew", value="\u65b0\u5546\u54c1", paramType="path", required=true), @ApiImplicitParam(name="isHot", value="\u70ed\u5356\u5546\u54c1", paramType="path", required=true)})
    @IgnoreAuth
    @PostMapping(value={"list"})
    public Object list(@LoginUser UserVo loginUser, Integer categoryId, Integer brandId, String keyword, Integer isNew, Integer isHot, @RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size, String sort, String order) {
        HashMap<String, Object> categoryParam;
        ArrayList<Integer> categoryIds;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("is_delete", 0);
        params.put("is_on_sale", 1);
        params.put("brand_id", brandId);
        params.put("name", keyword);
        params.put("is_new", isNew);
        params.put("is_hot", isHot);
        params.put("page", page);
        params.put("limit", size);
        params.put("order", sort);
        params.put("sidx", order);
        if (null != sort && sort.equals("price")) {
            params.put("sidx", "retail_price");
            params.put("order", order);
        } else {
            params.put("sidx", "id");
            params.put("order", "desc");
        }
        if (!StringUtils.isNullOrEmpty((String)keyword)) {
            String token = this.request.getHeader("X-Nideshop-Token");
            if (org.apache.commons.lang.StringUtils.isBlank((String)token)) {
                token = this.request.getParameter("X-Nideshop-Token");
            }
            TokenEntity tokenEntity = this.tokenService.queryByToken(token);
            SearchHistoryVo searchHistoryVo = new SearchHistoryVo();
            searchHistoryVo.setAdd_time(System.currentTimeMillis() / 1000L);
            searchHistoryVo.setKeyword(keyword);
            searchHistoryVo.setUser_id(null != tokenEntity ? tokenEntity.getUserId().toString() : "");
            searchHistoryVo.setFrom("");
            this.searchHistoryService.save(searchHistoryVo);
        }
        ArrayList<CategoryVo> filterCategory = new ArrayList<CategoryVo>();
        CategoryVo rootCategory = new CategoryVo();
        rootCategory.setId(0);
        rootCategory.setName("\u5168\u90e8");
        rootCategory.setChecked(false);
        filterCategory.add(rootCategory);
        params.put("fields", "category_id");
        List<GoodsVo> categoryEntityList = this.goodsService.queryList(params);
        params.remove("fields");
        if (null != categoryEntityList && categoryEntityList.size() > 0) {
            categoryIds = new ArrayList<Integer>();
            for (GoodsVo goodsVo : categoryEntityList) {
                categoryIds.add(goodsVo.getCategory_id());
            }
            categoryParam = new HashMap();
            categoryParam.put("ids", categoryIds);
            categoryParam.put("fields", "parent_id");
            List<CategoryVo> parentCategoryList = this.categoryService.queryList(categoryParam);
            ArrayList<Integer> parentIds = new ArrayList<Integer>();
            for (CategoryVo categoryEntity : parentCategoryList) {
                parentIds.add(categoryEntity.getParent_id());
            }
            categoryParam = new HashMap();
            categoryParam.put("fields", "id,name");
            categoryParam.put("order", "asc");
            categoryParam.put("sidx", "sort_order");
            categoryParam.put("ids", parentIds);
            List<CategoryVo> parentCategory = this.categoryService.queryList(categoryParam);
            if (null != parentCategory) {
                filterCategory.addAll(parentCategory);
            }
        }
        if (null != categoryId && categoryId > 0) {
            categoryIds = new ArrayList();
            categoryParam = new HashMap<String, Object>();
            categoryParam.put("parent_id", categoryId);
            categoryParam.put("fields", "id");
            List<CategoryVo> childIds = this.categoryService.queryList(categoryParam);
            for (CategoryVo categoryEntity : childIds) {
                categoryIds.add(categoryEntity.getId());
            }
            categoryIds.add(categoryId);
            params.put("categoryIds", categoryIds);
        }
        params.put("fields", "id, name, list_pic_url, market_price, retail_price, goods_brief");
        Query query = new Query(params);
        PageHelper.startPage((int)query.getPage(), (int)query.getLimit());
        List<GoodsVo> goodsList = this.goodsService.queryList((Map<String, Object>)query);
        ApiPageUtils goodsData = new ApiPageUtils(new PageInfo(goodsList));
        for (CategoryVo categoryEntity : filterCategory) {
            if (null != categoryId && (categoryEntity.getId() == 0 || categoryId.equals(categoryEntity.getId())) || null == categoryId && null == categoryEntity.getId()) {
                categoryEntity.setChecked(true);
                continue;
            }
            categoryEntity.setChecked(false);
        }
        goodsData.setFilterCategory(filterCategory);
        goodsData.setGoodsList(goodsList);
        return this.toResponsSuccess(goodsData);
    }

    @ApiOperation(value="\u5546\u54c1\u5217\u8868\u7b5b\u9009\u7684\u5206\u7c7b\u5217\u8868")
    @IgnoreAuth
    @PostMapping(value={"filter"})
    public Object filter(Integer categoryId, String keyword, Integer isNew, Integer isHot) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("is_delete", 0);
        params.put("is_on_sale", 1);
        params.put("categoryId", categoryId);
        params.put("keyword", keyword);
        params.put("isNew", isNew);
        params.put("isHot", isHot);
        if (null != categoryId) {
            HashMap<String, Object> categoryParams = new HashMap<String, Object>();
            categoryParams.put("categoryId", categoryId);
            List<CategoryVo> categoryEntityList = this.categoryService.queryList(categoryParams);
            ArrayList<Integer> category_ids = new ArrayList<Integer>();
            for (CategoryVo categoryVo : categoryEntityList) {
                category_ids.add(categoryVo.getId());
            }
            params.put("category_id", category_ids);
        }
        ArrayList<CategoryVo> filterCategory = new ArrayList<CategoryVo>();
        CategoryVo rootCategory = new CategoryVo();
        rootCategory.setId(0);
        rootCategory.setName("\u5168\u90e8");
        List<GoodsVo> goodsEntityList = this.goodsService.queryList(params);
        if (null != goodsEntityList && goodsEntityList.size() > 0) {
            ArrayList<Integer> categoryIds = new ArrayList<Integer>();
            for (GoodsVo goodsEntity : goodsEntityList) {
                categoryIds.add(goodsEntity.getCategory_id());
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("categoryIds", categoryIds);
            List<CategoryVo> parentCategoryList = this.categoryService.queryList(hashMap);
            ArrayList<Integer> parentIds = new ArrayList<Integer>();
            for (CategoryVo categoryEntity : parentCategoryList) {
                parentIds.add(categoryEntity.getId());
            }
            hashMap.put("categoryIds", parentIds);
            List<CategoryVo> parentCategory = this.categoryService.queryList(hashMap);
            if (null != parentCategory) {
                filterCategory.addAll(parentCategory);
            }
        }
        return this.toResponsSuccess(filterCategory);
    }

    @ApiOperation(value="\u65b0\u54c1\u9996\u53d1")
    @IgnoreAuth
    @PostMapping(value={"new"})
    public Object newAction() {
        HashMap resultObj = new HashMap();
        HashMap<String, String> bannerInfo = new HashMap<String, String>();
        bannerInfo.put("url", "");
        bannerInfo.put("name", "\u575a\u6301\u521d\u5fc3\uff0c\u4e3a\u4f60\u5bfb\u89c5\u4e16\u95f4\u597d\u7269");
        bannerInfo.put("img_url", "https://platform-wxmall.oss-cn-beijing.aliyuncs.com/upload/20180727/1504208321fef4.png");
        resultObj.put("bannerInfo", bannerInfo);
        return this.toResponsSuccess(resultObj);
    }

    @ApiOperation(value="\u4eba\u6c14\u63a8\u8350")
    @IgnoreAuth
    @PostMapping(value={"hot"})
    public Object hot() {
        HashMap resultObj = new HashMap();
        HashMap<String, String> bannerInfo = new HashMap<String, String>();
        bannerInfo.put("url", "");
        bannerInfo.put("name", "\u5927\u5bb6\u90fd\u5728\u4e70\u7684\u4e25\u9009\u597d\u7269");
        bannerInfo.put("img_url", "https://platform-wxmall.oss-cn-beijing.aliyuncs.com/upload/20180727/1504208321fef4.png");
        resultObj.put("bannerInfo", bannerInfo);
        return this.toResponsSuccess(resultObj);
    }

    @ApiOperation(value="\u5546\u54c1\u8be6\u60c5\u9875")
    @IgnoreAuth
    @PostMapping(value={"related"})
    public Object related(Integer id) {
        HashMap resultObj = new HashMap();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("goods_id", id);
        param.put("fields", "related_goods_id");
        List<RelatedGoodsVo> relatedGoodsEntityList = this.relatedGoodsService.queryList(param);
        ArrayList<Integer> relatedGoodsIds = new ArrayList<Integer>();
        for (RelatedGoodsVo relatedGoodsEntity : relatedGoodsEntityList) {
            relatedGoodsIds.add(relatedGoodsEntity.getRelated_goods_id());
        }
        List<Object> relatedGoods = new ArrayList();
        if (null == relatedGoodsIds || relatedGoodsIds.size() < 1) {
            GoodsVo goodsCategory = this.goodsService.queryObject(id);
            HashMap<String, Object> paramRelated = new HashMap<String, Object>();
            paramRelated.put("fields", "id, name, list_pic_url, retail_price");
            paramRelated.put("category_id", goodsCategory.getCategory_id());
            relatedGoods = this.goodsService.queryList(paramRelated);
        } else {
            HashMap<String, Object> paramRelated = new HashMap<String, Object>();
            paramRelated.put("goods_ids", relatedGoodsIds);
            paramRelated.put("fields", "id, name, list_pic_url, retail_price");
            relatedGoods = this.goodsService.queryList(paramRelated);
        }
        resultObj.put("goodsList", relatedGoods);
        return this.toResponsSuccess(resultObj);
    }

    @ApiOperation(value="\u5728\u552e\u7684\u5546\u54c1\u603b\u6570")
    @IgnoreAuth
    @PostMapping(value={"count"})
    public Object count() {
        HashMap<String, Integer> resultObj = new HashMap<String, Integer>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("is_delete", 0);
        param.put("is_on_sale", 1);
        Integer goodsCount = this.goodsService.queryTotal(param);
        resultObj.put("goodsCount", goodsCount);
        return this.toResponsSuccess(resultObj);
    }

    @ApiOperation(value="\u83b7\u53d6\u5546\u54c1\u5217\u8868")
    @IgnoreAuth
    @PostMapping(value={"productlist"})
    public Object productlist(Integer categoryId, Integer isNew, Integer discount, @RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("is_new", isNew);
        params.put("page", page);
        params.put("limit", size);
        params.put("order", sort);
        params.put("sidx", order);
        if (null != sort && sort.equals("price")) {
            params.put("sidx", "retail_price");
            params.put("order", order);
        } else if (null != sort && sort.equals("sell")) {
            params.put("sidx", "orderNum");
            params.put("order", order);
        } else {
            params.put("sidx", "id");
            params.put("order", "desc");
        }
        if (null != discount && discount == 1) {
            params.put("is_hot", 1);
        } else if (null != discount && discount == 2) {
            params.put("is_group", true);
        }
        if (null != categoryId && categoryId > 0) {
            ArrayList<Integer> categoryIds = new ArrayList<Integer>();
            HashMap<String, Object> categoryParam = new HashMap<String, Object>();
            categoryParam.put("parent_id", categoryId);
            categoryParam.put("fields", "id");
            List<CategoryVo> childIds = this.categoryService.queryList(categoryParam);
            for (CategoryVo categoryEntity : childIds) {
                categoryIds.add(categoryEntity.getId());
            }
            categoryIds.add(categoryId);
            params.put("categoryIds", categoryIds);
        }
        Query query = new Query(params);
        List<GoodsVo> goodsList = this.goodsService.queryCatalogProductList((Map<String, Object>)query);
        int total = this.goodsService.queryTotal((Map<String, Object>)query);
        List<Object> cartList = new ArrayList();
        if (null != this.getUserId()) {
            HashMap<String, Object> cartParam = new HashMap<String, Object>();
            cartParam.put("user_id", this.getUserId());
            cartList = this.cartService.queryList(cartParam);
        }
        if (null != cartList && cartList.size() > 0 && null != goodsList && goodsList.size() > 0) {
            for (GoodsVo goodsVo : goodsList) {
                for (CartVo cartVo : cartList) {
                    if (!goodsVo.getId().equals(cartVo.getGoods_id())) continue;
                    goodsVo.setCart_num(cartVo.getNumber());
                }
            }
        }
        ApiPageUtils goodsData = new ApiPageUtils(goodsList, total, query.getLimit(), query.getPage());
        goodsData.setGoodsList(goodsData.getData());
        return this.toResponsSuccess(goodsData);
    }
}

