/*
 * Decompiled with CFR 0.152.
 */
package com.platform.api;

import com.github.pagehelper.PageHelper;
import com.platform.annotation.LoginUser;
import com.platform.entity.FootprintVo;
import com.platform.entity.UserVo;
import com.platform.service.ApiFootprintService;
import com.platform.util.ApiBaseAction;
import com.platform.util.ApiPageUtils;
import com.platform.utils.DateUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8db3\u8ff9"})
@RestController
@RequestMapping(value={"/api/footprint"})
public class ApiFootprintController
extends ApiBaseAction {
    @Autowired
    private ApiFootprintService footprintService;

    @ApiOperation(value="\u5220\u9664\u8db3\u8ff9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="footprintId", value="\u8db3\u8ff9id", paramType="path", required=true)})
    @PostMapping(value={"delete"})
    public Object delete(@LoginUser UserVo loginUser, Integer footprintId) {
        if (footprintId == null) {
            return this.toResponsFail("\u5220\u9664\u51fa\u9519");
        }
        FootprintVo footprintEntity = this.footprintService.queryObject(footprintId);
        if (loginUser == null || loginUser.getUserId() == null || footprintEntity == null || footprintEntity.getGoods_id() == null) {
            return this.toResponsFail("\u5220\u9664\u51fa\u9519");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("userId", loginUser.getUserId());
        param.put("goodsId", footprintEntity.getGoods_id());
        this.footprintService.deleteByParam(param);
        return this.toResponsMsgSuccess("\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u83b7\u53d6\u8db3\u8ff9\u5217\u8868")
    @PostMapping(value={"list"})
    public Object list(@LoginUser UserVo loginUser, @RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size) {
        HashMap<String, Serializable> resultObj = new HashMap<String, Serializable>();
        PageHelper.startPage((int)0, (int)10, (boolean)false);
        List<FootprintVo> footprintVos = this.footprintService.queryListFootprint(loginUser.getUserId() + "");
        ApiPageUtils pageUtil = new ApiPageUtils(footprintVos, 0, size, page);
        TreeMap<String, ArrayList<FootprintVo>> footPrintMap = new TreeMap<String, ArrayList<FootprintVo>>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.compareTo(o1);
            }
        });
        if (null != footprintVos && footprintVos.size() > 0) {
            for (FootprintVo footprintVo : footprintVos) {
                String addTime = DateUtils.timeToStr((Long)footprintVo.getAdd_time(), (String)"yyyy-MM-dd");
                ArrayList<FootprintVo> tmpList = (ArrayList<FootprintVo>)footPrintMap.get(addTime);
                if (null == footPrintMap.get(addTime)) {
                    tmpList = new ArrayList<FootprintVo>();
                }
                tmpList.add(footprintVo);
                footPrintMap.put(addTime, tmpList);
            }
            ArrayList footprintVoList = new ArrayList();
            for (Map.Entry entry : footPrintMap.entrySet()) {
                footprintVoList.add(entry.getValue());
            }
            resultObj.put("count", Integer.valueOf(pageUtil.getCount()));
            resultObj.put("totalPages", Integer.valueOf(pageUtil.getTotalPages()));
            resultObj.put("numsPerPage", Integer.valueOf(pageUtil.getNumsPerPage()));
            resultObj.put("currentPage", Integer.valueOf(pageUtil.getCurrentPage()));
            resultObj.put("data", footprintVoList);
        }
        return this.toResponsSuccess(resultObj);
    }

    @ApiOperation(value="\u5206\u4eab\u8db3\u8ff9")
    @PostMapping(value={"sharelist"})
    public Object sharelist(@LoginUser UserVo loginUser, @RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size) {
        HashMap<String, List<FootprintVo>> resultObj = new HashMap<String, List<FootprintVo>>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sidx", "f.id");
        params.put("order", "desc");
        params.put("referrer", loginUser.getUserId());
        List<FootprintVo> footprintVos = this.footprintService.shareList(params);
        resultObj.put("data", footprintVos);
        return this.toResponsSuccess(resultObj);
    }
}

