/*
 * Decompiled with CFR 0.152.
 */
package com.platform.api;

import com.alibaba.fastjson.JSONObject;
import com.platform.annotation.LoginUser;
import com.platform.cache.J2CacheUtils;
import com.platform.entity.BuyGoodsVo;
import com.platform.entity.CartVo;
import com.platform.entity.CouponVo;
import com.platform.entity.ProductVo;
import com.platform.entity.SmsLogVo;
import com.platform.entity.UserCouponVo;
import com.platform.entity.UserVo;
import com.platform.service.ApiCartService;
import com.platform.service.ApiCouponService;
import com.platform.service.ApiProductService;
import com.platform.service.ApiUserCouponService;
import com.platform.service.ApiUserService;
import com.platform.util.ApiBaseAction;
import com.platform.utils.CharUtil;
import com.platform.utils.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f18\u60e0\u5238"})
@RestController
@RequestMapping(value={"/api/coupon"})
public class ApiCouponController
extends ApiBaseAction {
    @Autowired
    private ApiUserService apiUserService;
    @Autowired
    private ApiCouponService apiCouponService;
    @Autowired
    private ApiUserCouponService apiUserCouponService;
    @Autowired
    private ApiProductService apiProductService;
    @Autowired
    private ApiCartService apiCartService;

    @ApiOperation(value="\u83b7\u53d6\u4f18\u60e0\u5238\u5217\u8868")
    @PostMapping(value={"/list"})
    public Object list(@LoginUser UserVo loginUser) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("user_id", loginUser.getUserId());
        List<CouponVo> couponVos = this.apiCouponService.queryUserCoupons(param);
        return this.toResponsSuccess(couponVos);
    }

    @ApiOperation(value="\u6839\u636e\u5546\u54c1\u83b7\u53d6\u53ef\u7528\u4f18\u60e0\u5238\u5217\u8868")
    @PostMapping(value={"/listByGoods"})
    public Object listByGoods(@RequestParam(defaultValue="cart") String type, @LoginUser UserVo loginUser) {
        HashMap<String, Object> param;
        BigDecimal goodsTotalPrice = new BigDecimal(0.0);
        if (type.equals("cart")) {
            param = new HashMap<String, Object>();
            param.put("user_id", loginUser.getUserId());
            List<CartVo> cartList = this.apiCartService.queryList(param);
            for (CartVo cartItem : cartList) {
                if (null == cartItem.getChecked() || 1 != cartItem.getChecked()) continue;
                goodsTotalPrice = goodsTotalPrice.add(cartItem.getRetail_price().multiply(new BigDecimal(cartItem.getNumber())));
            }
        } else {
            BuyGoodsVo goodsVo = (BuyGoodsVo)J2CacheUtils.get((String)J2CacheUtils.SHOP_CACHE_NAME, (String)("goods" + loginUser.getUserId() + ""));
            ProductVo productInfo = this.apiProductService.queryObject(goodsVo.getProductId());
            goodsTotalPrice = productInfo.getRetail_price().multiply(new BigDecimal(goodsVo.getNumber()));
        }
        param = new HashMap();
        param.put("user_id", loginUser.getUserId());
        param.put("coupon_status", 1);
        List<CouponVo> couponVos = this.apiCouponService.queryUserCoupons(param);
        ArrayList<CouponVo> useCoupons = new ArrayList<CouponVo>();
        ArrayList<CouponVo> notUseCoupons = new ArrayList<CouponVo>();
        for (CouponVo couponVo : couponVos) {
            if (goodsTotalPrice.compareTo(couponVo.getMin_goods_amount()) >= 0) {
                couponVo.setEnabled(1);
                useCoupons.add(couponVo);
                continue;
            }
            couponVo.setEnabled(0);
            notUseCoupons.add(couponVo);
        }
        useCoupons.addAll(notUseCoupons);
        return this.toResponsSuccess(useCoupons);
    }

    @ApiOperation(value="\u9886\u5238\u4f18\u60e0\u5238")
    @PostMapping(value={"exchange"})
    public Object exchange(@LoginUser UserVo loginUser) {
        JSONObject jsonParam = this.getJsonRequest();
        String coupon_number = jsonParam.getString("coupon_number");
        if (StringUtils.isNullOrEmpty((Object)coupon_number)) {
            return this.toResponsFail("\u5f53\u524d\u4f18\u60e0\u7801\u65e0\u6548");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("coupon_number", coupon_number);
        List<UserCouponVo> couponVos = this.apiUserCouponService.queryList(param);
        UserCouponVo userCouponVo = null;
        if (null == couponVos || couponVos.size() == 0) {
            return this.toResponsFail("\u5f53\u524d\u4f18\u60e0\u7801\u65e0\u6548");
        }
        userCouponVo = couponVos.get(0);
        if (null != userCouponVo.getUser_id() && !userCouponVo.getUser_id().equals(0L)) {
            return this.toResponsFail("\u5f53\u524d\u4f18\u60e0\u7801\u5df2\u7ecf\u5151\u6362");
        }
        CouponVo couponVo = this.apiCouponService.queryObject(userCouponVo.getCoupon_id());
        if (null == couponVo || null == couponVo.getUse_end_date() || couponVo.getUse_end_date().before(new Date())) {
            return this.toResponsFail("\u5f53\u524d\u4f18\u60e0\u7801\u5df2\u7ecf\u8fc7\u671f");
        }
        userCouponVo.setUser_id(loginUser.getUserId());
        userCouponVo.setAdd_time(new Date());
        this.apiUserCouponService.update(userCouponVo);
        return this.toResponsSuccess(userCouponVo);
    }

    @ApiOperation(value="\u9886\u5238\u4f18\u60e0\u5238")
    @PostMapping(value={"newuser"})
    public Object newuser(@LoginUser UserVo loginUser) {
        JSONObject jsonParam = this.getJsonRequest();
        String phone = jsonParam.getString("phone");
        Integer smscode = jsonParam.getInteger("smscode");
        SmsLogVo smsLogVo = this.apiUserService.querySmsCodeByUserId(loginUser.getUserId());
        if (null != smsLogVo && smsLogVo.getSms_code() != smscode.intValue()) {
            return this.toResponsFail("\u77ed\u4fe1\u6821\u9a8c\u5931\u8d25");
        }
        if (!StringUtils.isNullOrEmpty((Object)phone) && phone.equals(loginUser.getMobile())) {
            loginUser.setMobile(phone);
            this.apiUserService.update(loginUser);
        }
        if (!StringUtils.isNullOrEmpty((Object)loginUser.getMobile())) {
            return this.toResponsFail("\u5f53\u524d\u4f18\u60e0\u5238\u53ea\u80fd\u65b0\u7528\u6237\u9886\u53d6");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("user_id", loginUser.getUserId());
        params.put("send_type", 4);
        List<CouponVo> couponVos = this.apiCouponService.queryUserCoupons(params);
        if (null != couponVos && couponVos.size() > 0) {
            return this.toResponsFail("\u5df2\u7ecf\u9886\u53d6\u8fc7\uff0c\u4e0d\u80fd\u91cd\u590d\u9886\u53d6");
        }
        HashMap<String, Object> couponParam = new HashMap<String, Object>();
        couponParam.put("send_type", 4);
        CouponVo newCouponConfig = this.apiCouponService.queryMaxUserEnableCoupon(couponParam);
        if (null != newCouponConfig) {
            UserCouponVo userCouponVo = new UserCouponVo();
            userCouponVo.setAdd_time(new Date());
            userCouponVo.setCoupon_id(newCouponConfig.getId());
            userCouponVo.setCoupon_number(CharUtil.getRandomString((Integer)12));
            userCouponVo.setUser_id(loginUser.getUserId());
            this.apiUserCouponService.save(userCouponVo);
            return this.toResponsSuccess(userCouponVo);
        }
        return this.toResponsFail("\u9886\u53d6\u5931\u8d25");
    }

    @ApiOperation(value="\u8f6c\u53d1\u9886\u53d6\u7ea2\u5305")
    @PostMapping(value={"transActivit"})
    public Object transActivit(@LoginUser UserVo loginUser, String sourceKey, Long referrer) {
        JSONObject jsonParam = this.getJsonRequest();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("user_id", loginUser.getUserId());
        params.put("send_type", 2);
        params.put("source_key", sourceKey);
        List<CouponVo> couponVos = this.apiCouponService.queryUserCoupons(params);
        if (null != couponVos && couponVos.size() > 0) {
            return this.toResponsObject(2, "\u5df2\u7ecf\u9886\u53d6\u8fc7", couponVos);
        }
        HashMap<String, Object> couponParam = new HashMap<String, Object>();
        couponParam.put("send_type", 2);
        CouponVo newCouponConfig = this.apiCouponService.queryMaxUserEnableCoupon(couponParam);
        if (null != newCouponConfig) {
            UserCouponVo userCouponVo = new UserCouponVo();
            userCouponVo.setAdd_time(new Date());
            userCouponVo.setCoupon_id(newCouponConfig.getId());
            userCouponVo.setCoupon_number(CharUtil.getRandomString((Integer)12));
            userCouponVo.setUser_id(loginUser.getUserId());
            userCouponVo.setSource_key(sourceKey);
            userCouponVo.setReferrer(referrer);
            this.apiUserCouponService.save(userCouponVo);
            ArrayList<UserCouponVo> userCouponVos = new ArrayList<UserCouponVo>();
            userCouponVos.add(userCouponVo);
            params = new HashMap();
            params.put("user_id", loginUser.getUserId());
            params.put("send_type", 2);
            params.put("source_key", sourceKey);
            couponVos = this.apiCouponService.queryUserCoupons(params);
            return this.toResponsSuccess(couponVos);
        }
        return this.toResponsFail("\u9886\u53d6\u5931\u8d25");
    }
}

