/*
 * Decompiled with CFR 0.152.
 */
package com.platform.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.platform.annotation.IgnoreAuth;
import com.platform.annotation.LoginUser;
import com.platform.entity.CommentPictureVo;
import com.platform.entity.CommentVo;
import com.platform.entity.CouponVo;
import com.platform.entity.UserCouponVo;
import com.platform.entity.UserVo;
import com.platform.service.ApiCommentPictureService;
import com.platform.service.ApiCommentService;
import com.platform.service.ApiCouponService;
import com.platform.service.ApiUserCouponService;
import com.platform.service.ApiUserService;
import com.platform.util.ApiBaseAction;
import com.platform.util.ApiPageUtils;
import com.platform.utils.Base64Util;
import com.platform.utils.CharUtil;
import com.platform.utils.Query;
import com.platform.utils.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8bc4\u8bba"})
@RestController
@RequestMapping(value={"/api/comment"})
public class ApiCommentController
extends ApiBaseAction {
    @Autowired
    private ApiCommentService commentService;
    @Autowired
    private ApiUserService userService;
    @Autowired
    private ApiCommentPictureService commentPictureService;
    @Autowired
    private ApiCouponService apiCouponService;
    @Autowired
    private ApiUserCouponService apiUserCouponService;

    @ApiOperation(value="\u53d1\u8868\u8bc4\u8bba")
    @PostMapping(value={"post"})
    public Object post(@LoginUser UserVo loginUser) {
        HashMap<String, CouponVo> resultObj = new HashMap<String, CouponVo>();
        JSONObject jsonParam = this.getJsonRequest();
        Integer typeId = jsonParam.getInteger("typeId");
        Integer valueId = jsonParam.getInteger("valueId");
        String content = jsonParam.getString("content");
        JSONArray imagesList = jsonParam.getJSONArray("imagesList");
        CommentVo commentEntity = new CommentVo();
        commentEntity.setType_id(typeId);
        commentEntity.setValue_id(valueId);
        commentEntity.setContent(content);
        commentEntity.setStatus(0);
        commentEntity.setAdd_time(System.currentTimeMillis() / 1000L);
        commentEntity.setUser_id(loginUser.getUserId());
        commentEntity.setContent(Base64Util.encode((String)commentEntity.getContent()));
        Integer insertId = this.commentService.save(commentEntity);
        if (insertId > 0 && null != imagesList && imagesList.size() > 0) {
            int i = 0;
            for (Object imgLink : imagesList) {
                CommentPictureVo pictureVo = new CommentPictureVo();
                pictureVo.setComment_id(insertId);
                pictureVo.setPic_url(imgLink.toString());
                pictureVo.setSort_order(++i);
                this.commentPictureService.save(pictureVo);
            }
        }
        if (insertId > 0 && typeId == 0) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("value_id", valueId);
            List<CommentVo> commentVos = this.commentService.queryList(param);
            boolean hasComment = false;
            for (CommentVo commentVo : commentVos) {
                if (!commentVo.getUser_id().equals(loginUser.getUserId()) || commentVo.getId().equals(insertId)) continue;
                hasComment = true;
            }
            if (!hasComment) {
                HashMap<String, Object> couponParam = new HashMap<String, Object>();
                couponParam.put("send_type", 6);
                CouponVo newCouponConfig = this.apiCouponService.queryMaxUserEnableCoupon(couponParam);
                if (null != newCouponConfig && newCouponConfig.getMin_transmit_num() >= commentVos.size()) {
                    UserCouponVo userCouponVo = new UserCouponVo();
                    userCouponVo.setAdd_time(new Date());
                    userCouponVo.setCoupon_id(newCouponConfig.getId());
                    userCouponVo.setCoupon_number(CharUtil.getRandomString((Integer)12));
                    userCouponVo.setUser_id(loginUser.getUserId());
                    this.apiUserCouponService.save(userCouponVo);
                    resultObj.put("coupon", newCouponConfig);
                }
            }
        }
        if (insertId > 0) {
            return this.toResponsObject(0, "\u8bc4\u8bba\u6dfb\u52a0\u6210\u529f", resultObj);
        }
        return this.toResponsFail("\u8bc4\u8bba\u4fdd\u5b58\u5931\u8d25");
    }

    @ApiOperation(value="\u8bc4\u8bba\u6570\u91cf")
    @PostMapping(value={"count"})
    public Object count(Integer typeId, Integer valueId) {
        HashMap<String, Integer> resultObj = new HashMap<String, Integer>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("type_id", typeId);
        param.put("value_id", valueId);
        Integer allCount = this.commentService.queryTotal(param);
        Integer hasPicCount = this.commentService.queryhasPicTotal(param);
        resultObj.put("allCount", allCount);
        resultObj.put("hasPicCount", hasPicCount);
        return this.toResponsSuccess(resultObj);
    }

    @ApiOperation(value="\u9009\u62e9\u8bc4\u8bba\u7c7b\u578b")
    @IgnoreAuth
    @PostMapping(value={"list"})
    public Object list(Integer typeId, Integer valueId, Integer showType, @RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size, String sort, String order) {
        HashMap resultObj = new HashMap();
        List<Object> commentList = new ArrayList();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("type_id", typeId);
        param.put("value_id", valueId);
        param.put("page", page);
        param.put("limit", size);
        if (StringUtils.isNullOrEmpty((Object)sort)) {
            param.put("order", "desc");
        } else {
            param.put("order", sort);
        }
        if (StringUtils.isNullOrEmpty((Object)order)) {
            param.put("sidx", "id");
        } else {
            param.put("sidx", order);
        }
        if (null != showType && showType == 1) {
            param.put("hasPic", 1);
        }
        Query query = new Query(param);
        commentList = this.commentService.queryList((Map<String, Object>)query);
        int total = this.commentService.queryTotal((Map<String, Object>)query);
        ApiPageUtils pageUtil = new ApiPageUtils(commentList, total, query.getLimit(), query.getPage());
        for (CommentVo commentVo : commentList) {
            commentVo.setContent(Base64Util.decode((String)commentVo.getContent()));
            commentVo.setUser_info(this.userService.queryObject(commentVo.getUser_id()));
            HashMap<String, Object> paramPicture = new HashMap<String, Object>();
            paramPicture.put("comment_id", commentVo.getId());
            List<CommentPictureVo> commentPictureEntities = this.commentPictureService.queryList(paramPicture);
            commentVo.setPic_list(commentPictureEntities);
        }
        return this.toResponsSuccess(pageUtil);
    }
}

