/*
 * Decompiled with CFR 0.152.
 */
package com.platform.api;

import com.alibaba.fastjson.JSONObject;
import com.platform.annotation.LoginUser;
import com.platform.entity.CollectVo;
import com.platform.entity.UserVo;
import com.platform.service.ApiCollectService;
import com.platform.util.ApiBaseAction;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7528\u6237\u6536\u85cf"})
@RestController
@RequestMapping(value={"/api/collect"})
public class ApiCollectController
extends ApiBaseAction {
    @Autowired
    private ApiCollectService collectService;

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6536\u85cf")
    @PostMapping(value={"list"})
    public Object list(@LoginUser UserVo loginUser, Integer typeId) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("user_id", loginUser.getUserId());
        param.put("type_id", typeId);
        List<CollectVo> collectEntities = this.collectService.queryList(param);
        return this.toResponsSuccess(collectEntities);
    }

    @ApiOperation(value="\u6dfb\u52a0\u53d6\u6d88\u6536\u85cf")
    @PostMapping(value={"addordelete"})
    public Object addordelete(@LoginUser UserVo loginUser) {
        JSONObject jsonParam = this.getJsonRequest();
        Integer typeId = jsonParam.getInteger("typeId");
        Integer valueId = jsonParam.getInteger("valueId");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("user_id", loginUser.getUserId());
        param.put("type_id", typeId);
        param.put("value_id", valueId);
        List<CollectVo> collectEntities = this.collectService.queryList(param);
        Integer collectRes = null;
        String handleType = "add";
        if (null == collectEntities || collectEntities.size() < 1) {
            CollectVo collectEntity = new CollectVo();
            collectEntity.setAdd_time(System.currentTimeMillis() / 1000L);
            collectEntity.setType_id(typeId);
            collectEntity.setValue_id(valueId);
            collectEntity.setIs_attention(0);
            collectEntity.setUser_id(loginUser.getUserId());
            collectRes = this.collectService.save(collectEntity);
        } else {
            collectRes = this.collectService.delete(collectEntities.get(0).getId());
            handleType = "delete";
        }
        if (collectRes > 0) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("type", handleType);
            return this.toResponsSuccess(data);
        }
        return this.toResponsFail("\u64cd\u4f5c\u5931\u8d25");
    }
}

