/*
 * Decompiled with CFR 0.152.
 */
package com.platform.api;

import com.alibaba.fastjson.JSONObject;
import com.platform.annotation.IgnoreAuth;
import com.platform.annotation.LoginUser;
import com.platform.cache.J2CacheUtils;
import com.platform.dao.ApiCouponMapper;
import com.platform.entity.AddressVo;
import com.platform.entity.BuyGoodsVo;
import com.platform.entity.CartVo;
import com.platform.entity.CouponInfoVo;
import com.platform.entity.CouponVo;
import com.platform.entity.GoodsSpecificationVo;
import com.platform.entity.GoodsVo;
import com.platform.entity.ProductVo;
import com.platform.entity.TokenEntity;
import com.platform.entity.UserVo;
import com.platform.service.ApiAddressService;
import com.platform.service.ApiCartService;
import com.platform.service.ApiCouponService;
import com.platform.service.ApiGoodsService;
import com.platform.service.ApiGoodsSpecificationService;
import com.platform.service.ApiProductService;
import com.platform.util.ApiBaseAction;
import com.qiniu.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d2d\u7269\u8f66"})
@RestController
@RequestMapping(value={"/api/cart"})
public class ApiCartController
extends ApiBaseAction {
    @Autowired
    private ApiCartService cartService;
    @Autowired
    private ApiGoodsService goodsService;
    @Autowired
    private ApiProductService productService;
    @Autowired
    private ApiGoodsSpecificationService goodsSpecificationService;
    @Autowired
    private ApiAddressService addressService;
    @Autowired
    private ApiCouponService apiCouponService;
    @Autowired
    private ApiCouponMapper apiCouponMapper;

    @ApiOperation(value="\u83b7\u53d6\u8d2d\u7269\u8f66\u4e2d\u7684\u6570\u636e")
    @PostMapping(value={"getCart"})
    public Object getCart(@LoginUser UserVo loginUser) {
        HashMap<String, Object> resultObj = new HashMap<String, Object>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("user_id", loginUser.getUserId());
        List<CartVo> cartList = this.cartService.queryList(param);
        Integer goodsCount = 0;
        BigDecimal goodsAmount = new BigDecimal(0.0);
        Integer checkedGoodsCount = 0;
        BigDecimal checkedGoodsAmount = new BigDecimal(0.0);
        for (CartVo cartItem : cartList) {
            goodsCount = goodsCount + cartItem.getNumber();
            goodsAmount = goodsAmount.add(cartItem.getRetail_price().multiply(new BigDecimal(cartItem.getNumber())));
            if (null == cartItem.getChecked() || 1 != cartItem.getChecked()) continue;
            checkedGoodsCount = checkedGoodsCount + cartItem.getNumber();
            checkedGoodsAmount = checkedGoodsAmount.add(cartItem.getRetail_price().multiply(new BigDecimal(cartItem.getNumber())));
        }
        HashMap<String, Object> couponParam = new HashMap<String, Object>();
        couponParam.put("enabled", true);
        Integer[] send_types = new Integer[]{0, 7};
        couponParam.put("send_types", send_types);
        ArrayList<CouponInfoVo> couponInfoList = new ArrayList<CouponInfoVo>();
        List<CouponVo> couponVos = this.apiCouponService.queryList(couponParam);
        if (null != couponVos && couponVos.size() > 0) {
            CouponInfoVo fullCutVo = new CouponInfoVo();
            BigDecimal fullCutDec = new BigDecimal(0);
            BigDecimal minAmount = new BigDecimal(100000);
            for (CouponVo couponVo : couponVos) {
                CouponInfoVo cpVo;
                BigDecimal difDec = couponVo.getMin_goods_amount().subtract(checkedGoodsAmount).setScale(2, 4);
                if (couponVo.getSend_type() == 0 && difDec.doubleValue() > 0.0 && minAmount.compareTo(couponVo.getMin_goods_amount()) > 0) {
                    fullCutDec = couponVo.getType_money();
                    minAmount = couponVo.getMin_goods_amount();
                    fullCutVo.setType(1);
                    fullCutVo.setMsg(couponVo.getName() + "\uff0c\u8fd8\u5dee" + difDec + "\u5143");
                } else if (couponVo.getSend_type() == 0 && difDec.doubleValue() < 0.0 && fullCutDec.compareTo(couponVo.getType_money()) < 0) {
                    fullCutDec = couponVo.getType_money();
                    fullCutVo.setType(0);
                    fullCutVo.setMsg("\u53ef\u4f7f\u7528\u6ee1\u51cf\u5238" + couponVo.getName());
                }
                if (couponVo.getSend_type() == 7 && difDec.doubleValue() > 0.0) {
                    cpVo = new CouponInfoVo();
                    cpVo.setMsg("\u6ee1\uffe5" + couponVo.getMin_amount() + "\u5143\u514d\u914d\u9001\u8d39\uff0c\u8fd8\u5dee" + difDec + "\u5143");
                    cpVo.setType(1);
                    couponInfoList.add(cpVo);
                    continue;
                }
                if (couponVo.getSend_type() != 7) continue;
                cpVo = new CouponInfoVo();
                cpVo.setMsg("\u6ee1\uffe5" + couponVo.getMin_amount() + "\u5143\u514d\u914d\u9001\u8d39");
                couponInfoList.add(cpVo);
            }
            if (!StringUtils.isNullOrEmpty((String)fullCutVo.getMsg())) {
                couponInfoList.add(fullCutVo);
            }
        }
        resultObj.put("couponInfoList", couponInfoList);
        resultObj.put("cartList", cartList);
        HashMap<String, Number> cartTotal = new HashMap<String, Number>();
        cartTotal.put("goodsCount", goodsCount);
        cartTotal.put("goodsAmount", goodsAmount);
        cartTotal.put("checkedGoodsCount", checkedGoodsCount);
        cartTotal.put("checkedGoodsAmount", checkedGoodsAmount);
        resultObj.put("cartTotal", cartTotal);
        return resultObj;
    }

    @ApiOperation(value="\u83b7\u53d6\u8d2d\u7269\u8f66\u4fe1\u606f")
    @PostMapping(value={"index"})
    public Object index(@LoginUser UserVo loginUser) {
        return this.toResponsSuccess(this.getCart(loginUser));
    }

    private String[] getSpecificationIdsArray(String ids) {
        String[] tempArray;
        String[] idsArray = null;
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)ids) && null != (tempArray = ids.split("_")) && tempArray.length > 0) {
            idsArray = tempArray;
        }
        return idsArray;
    }

    @ApiOperation(value="\u6dfb\u52a0\u5546\u54c1\u5230\u8d2d\u7269\u8f66")
    @PostMapping(value={"add"})
    public Object add(@LoginUser UserVo loginUser) {
        CartVo cartInfo;
        JSONObject jsonParam = this.getJsonRequest();
        Integer goodsId = jsonParam.getInteger("goodsId");
        Integer productId = jsonParam.getInteger("productId");
        Integer number = jsonParam.getInteger("number");
        String goodsSpecificationIds = jsonParam.getString("goodsSpecificationIds");
        GoodsVo goodsInfo = this.goodsService.queryObject(goodsId);
        if (null == goodsInfo || goodsInfo.getIs_delete() == 1 || goodsInfo.getIs_on_sale() != 1) {
            return this.toResponsObject(400, "\u5546\u54c1\u5df2\u4e0b\u67b6", "");
        }
        ProductVo productInfo = this.productService.queryObject(productId);
        if (null == productInfo || productInfo.getGoods_number() < number) {
            return this.toResponsObject(400, "\u5e93\u5b58\u4e0d\u8db3", "");
        }
        HashMap<String, Object> cartParam = new HashMap<String, Object>();
        cartParam.put("goods_id", goodsId);
        cartParam.put("product_id", productId);
        cartParam.put("user_id", loginUser.getUserId());
        cartParam.put("goods_specification_ids", goodsSpecificationIds);
        List<CartVo> cartInfoList = this.cartService.queryList(cartParam);
        CartVo cartVo = cartInfo = null != cartInfoList && cartInfoList.size() > 0 ? cartInfoList.get(0) : null;
        if (null == cartInfo) {
            Object[] goodsSepcifitionValue = null;
            String listPicUrl = "";
            if (null != productInfo.getGoods_specification_ids() && productInfo.getGoods_specification_ids().length() > 0) {
                HashMap<String, Object> specificationParam = new HashMap<String, Object>();
                String[] idsArray = this.getSpecificationIdsArray(goodsSpecificationIds);
                specificationParam.put("ids", idsArray);
                specificationParam.put("goods_id", goodsId);
                List<GoodsSpecificationVo> specificationEntities = this.goodsSpecificationService.queryList(specificationParam);
                goodsSepcifitionValue = new String[specificationEntities.size()];
                for (int i = 0; i < specificationEntities.size(); ++i) {
                    goodsSepcifitionValue[i] = specificationEntities.get(i).getValue();
                    listPicUrl = specificationEntities.get(i).getPic_url();
                }
            }
            cartInfo = new CartVo();
            if ("".equals(listPicUrl)) {
                listPicUrl = goodsInfo.getList_pic_url();
            }
            cartInfo.setGoods_id(goodsId);
            cartInfo.setProduct_id(productId);
            cartInfo.setGoods_sn(productInfo.getGoods_sn());
            cartInfo.setGoods_name(goodsInfo.getName());
            cartInfo.setList_pic_url(listPicUrl);
            cartInfo.setNumber(number);
            cartInfo.setSession_id("1");
            cartInfo.setUser_id(loginUser.getUserId());
            cartInfo.setRetail_price(productInfo.getRetail_price());
            cartInfo.setMarket_price(productInfo.getMarket_price());
            if (null != goodsSepcifitionValue) {
                cartInfo.setGoods_specifition_name_value(StringUtils.join((Object[])goodsSepcifitionValue, (String)";"));
            }
            cartInfo.setGoods_specifition_ids(goodsSpecificationIds);
            cartInfo.setChecked(0);
            this.cartService.save(cartInfo);
        } else {
            if (productInfo.getGoods_number() < number + cartInfo.getNumber()) {
                return this.toResponsObject(400, "\u5e93\u5b58\u4e0d\u8db3", "");
            }
            cartInfo.setNumber(cartInfo.getNumber() + number);
            this.cartService.update(cartInfo);
        }
        return this.toResponsSuccess(this.getCart(loginUser));
    }

    @ApiOperation(value="\u51cf\u5c11\u5546\u54c1\u5230\u8d2d\u7269\u8f66")
    @PostMapping(value={"minus"})
    public Object minus(@LoginUser UserVo loginUser) {
        JSONObject jsonParam = this.getJsonRequest();
        Integer goodsId = jsonParam.getInteger("goodsId");
        Integer productId = jsonParam.getInteger("productId");
        Integer number = jsonParam.getInteger("number");
        HashMap<String, Object> cartParam = new HashMap<String, Object>();
        cartParam.put("goods_id", goodsId);
        cartParam.put("product_id", productId);
        cartParam.put("user_id", loginUser.getUserId());
        List<CartVo> cartInfoList = this.cartService.queryList(cartParam);
        CartVo cartInfo = null != cartInfoList && cartInfoList.size() > 0 ? cartInfoList.get(0) : null;
        int cart_num = 0;
        if (null != cartInfo) {
            if (cartInfo.getNumber() > number) {
                cartInfo.setNumber(cartInfo.getNumber() - number);
                this.cartService.update(cartInfo);
                cart_num = cartInfo.getNumber();
            } else if (cartInfo.getNumber() == 1) {
                this.cartService.delete(cartInfo.getId());
                cart_num = 0;
            }
        }
        return this.toResponsSuccess(cart_num);
    }

    @ApiOperation(value="\u66f4\u65b0\u6307\u5b9a\u7684\u8d2d\u7269\u8f66\u4fe1\u606f")
    @PostMapping(value={"update"})
    public Object update(@LoginUser UserVo loginUser, @RequestParam Integer goodsId, @RequestParam Integer productId, @RequestParam Integer number, @RequestParam Integer id) {
        CartVo newcartInfo;
        JSONObject jsonParam = this.getJsonRequest();
        ProductVo productInfo = this.productService.queryObject(productId);
        if (null == productInfo || productInfo.getGoods_number() < number) {
            return this.toResponsObject(400, "\u5e93\u5b58\u4e0d\u8db3", "");
        }
        CartVo cartInfo = this.cartService.queryObject(id);
        if (cartInfo.getProduct_id().equals(productId)) {
            cartInfo.setNumber(number);
            this.cartService.update(cartInfo);
            return this.toResponsSuccess(this.getCart(loginUser));
        }
        HashMap<String, Object> cartParam = new HashMap<String, Object>();
        cartParam.put("goodsId", goodsId);
        cartParam.put("productId", productId);
        List<CartVo> cartInfoList = this.cartService.queryList(cartParam);
        CartVo cartVo = newcartInfo = null != cartInfoList && cartInfoList.size() > 0 ? cartInfoList.get(0) : null;
        if (null == newcartInfo) {
            Object[] goodsSepcifitionValue = null;
            if (null != productInfo.getGoods_specification_ids()) {
                HashMap<String, Object> specificationParam = new HashMap<String, Object>();
                specificationParam.put("ids", productInfo.getGoods_specification_ids());
                specificationParam.put("goodsId", goodsId);
                List<GoodsSpecificationVo> specificationEntities = this.goodsSpecificationService.queryList(specificationParam);
                goodsSepcifitionValue = new String[specificationEntities.size()];
                for (int i = 0; i < specificationEntities.size(); ++i) {
                    goodsSepcifitionValue[i] = specificationEntities.get(i).getValue();
                }
            }
            cartInfo.setProduct_id(productId);
            cartInfo.setGoods_sn(productInfo.getGoods_sn());
            cartInfo.setNumber(number);
            cartInfo.setRetail_price(productInfo.getRetail_price());
            cartInfo.setMarket_price(productInfo.getRetail_price());
            if (null != goodsSepcifitionValue) {
                cartInfo.setGoods_specifition_name_value(StringUtils.join((Object[])goodsSepcifitionValue, (String)";"));
            }
            cartInfo.setGoods_specifition_ids(productInfo.getGoods_specification_ids());
            this.cartService.update(cartInfo);
        } else {
            Integer newNumber = number + newcartInfo.getNumber();
            if (null == productInfo || productInfo.getGoods_number() < newNumber) {
                return this.toResponsObject(400, "\u5e93\u5b58\u4e0d\u8db3", "");
            }
            this.cartService.delete(newcartInfo.getId());
            Object[] goodsSepcifitionValue = null;
            if (null != productInfo.getGoods_specification_ids()) {
                HashMap<String, Object> specificationParam = new HashMap<String, Object>();
                specificationParam.put("ids", productInfo.getGoods_specification_ids());
                specificationParam.put("goodsId", goodsId);
                List<GoodsSpecificationVo> specificationEntities = this.goodsSpecificationService.queryList(specificationParam);
                goodsSepcifitionValue = new String[specificationEntities.size()];
                for (int i = 0; i < specificationEntities.size(); ++i) {
                    goodsSepcifitionValue[i] = specificationEntities.get(i).getValue();
                }
            }
            cartInfo.setProduct_id(productId);
            cartInfo.setGoods_sn(productInfo.getGoods_sn());
            cartInfo.setNumber(number);
            cartInfo.setRetail_price(productInfo.getRetail_price());
            cartInfo.setMarket_price(productInfo.getRetail_price());
            if (null != goodsSepcifitionValue) {
                cartInfo.setGoods_specifition_name_value(StringUtils.join((Object[])goodsSepcifitionValue, (String)";"));
            }
            cartInfo.setGoods_specifition_ids(productInfo.getGoods_specification_ids());
            this.cartService.update(cartInfo);
        }
        return this.toResponsSuccess(this.getCart(loginUser));
    }

    @ApiOperation(value="\u662f\u5426\u9009\u62e9\u5546\u54c1")
    @PostMapping(value={"checked"})
    public Object checked(@LoginUser UserVo loginUser) {
        JSONObject jsonParam = this.getJsonRequest();
        String productIds = jsonParam.getString("productIds");
        Integer isChecked = jsonParam.getInteger("isChecked");
        if (StringUtils.isNullOrEmpty((String)productIds)) {
            return this.toResponsFail("\u5220\u9664\u51fa\u9519");
        }
        String[] productIdArray = productIds.split(",");
        this.cartService.updateCheck(productIdArray, isChecked, loginUser.getUserId());
        return this.toResponsSuccess(this.getCart(loginUser));
    }

    @ApiOperation(value="\u5220\u9664\u5546\u54c1")
    @PostMapping(value={"delete"})
    public Object delete(@LoginUser UserVo loginUser) {
        Long userId = loginUser.getUserId();
        JSONObject jsonObject = this.getJsonRequest();
        String productIds = jsonObject.getString("productIds");
        if (StringUtils.isNullOrEmpty((String)productIds)) {
            return this.toResponsFail("\u5220\u9664\u51fa\u9519");
        }
        String[] productIdsArray = productIds.split(",");
        this.cartService.deleteByUserAndProductIds(userId, productIdsArray);
        return this.toResponsSuccess(this.getCart(loginUser));
    }

    @ApiOperation(value="\u83b7\u53d6\u8d2d\u7269\u8f66\u5546\u54c1\u7684\u603b\u4ef6\u4ef6\u6570")
    @IgnoreAuth
    @PostMapping(value={"goodscount"})
    public Object goodscount() {
        HashMap<String, Object> resultObj = new HashMap<String, Object>();
        HashMap<String, Integer> cartTotal = new HashMap<String, Integer>();
        cartTotal.put("goodsCount", 0);
        resultObj.put("cartTotal", cartTotal);
        String token = this.request.getHeader("X-Nideshop-Token");
        if (org.apache.commons.lang.StringUtils.isBlank((String)token)) {
            token = this.request.getParameter("X-Nideshop-Token");
        }
        if (org.apache.commons.lang.StringUtils.isBlank((String)token)) {
            return this.toResponsSuccess(resultObj);
        }
        TokenEntity tokenEntity = this.tokenService.queryByToken(token);
        if (tokenEntity == null || tokenEntity.getExpireTime().getTime() < System.currentTimeMillis()) {
            return this.toResponsSuccess(resultObj);
        }
        if (null == tokenEntity.getUserId()) {
            return this.toResponsSuccess(resultObj);
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("user_id", tokenEntity.getUserId());
        List<CartVo> cartList = this.cartService.queryList(param);
        Integer goodsCount = 0;
        for (CartVo cartItem : cartList) {
            goodsCount = goodsCount + cartItem.getNumber();
        }
        resultObj.put("cartList", cartList);
        cartTotal = new HashMap();
        cartTotal.put("goodsCount", goodsCount);
        resultObj.put("cartTotal", cartTotal);
        return this.toResponsSuccess(resultObj);
    }

    @ApiOperation(value="\u8ba2\u5355\u63d0\u4ea4\u524d\u7684\u68c0\u9a8c\u548c\u586b\u5199\u76f8\u5173\u8ba2\u5355\u4fe1\u606f")
    @PostMapping(value={"checkout"})
    public Object checkout(@LoginUser UserVo loginUser, Integer couponId, @RequestParam(defaultValue="cart") String type) {
        CouponVo couponVo;
        BigDecimal goodsTotalPrice;
        HashMap<String, Serializable> resultObj = new HashMap<String, Serializable>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("user_id", loginUser.getUserId());
        List<AddressVo> addressEntities = this.addressService.queryList(param);
        if (null == addressEntities || addressEntities.size() == 0) {
            resultObj.put("checkedAddress", new AddressVo());
        } else {
            resultObj.put("checkedAddress", addressEntities.get(0));
            for (AddressVo vo : addressEntities) {
                if (vo.getIs_default() != 1) continue;
                resultObj.put("checkedAddress", vo);
                break;
            }
        }
        ArrayList<CartVo> checkedGoodsList = new ArrayList<CartVo>();
        if (type.equals("cart")) {
            Map cartData = (Map)this.getCart(loginUser);
            for (CartVo cartEntity : (List)cartData.get("cartList")) {
                if (cartEntity.getChecked() != 1) continue;
                checkedGoodsList.add(cartEntity);
            }
            goodsTotalPrice = (BigDecimal)((HashMap)cartData.get("cartTotal")).get("checkedGoodsAmount");
        } else {
            BuyGoodsVo goodsVO = (BuyGoodsVo)J2CacheUtils.get((String)J2CacheUtils.SHOP_CACHE_NAME, (String)("goods" + loginUser.getUserId() + ""));
            ProductVo productInfo = this.productService.queryObject(goodsVO.getProductId());
            goodsTotalPrice = productInfo.getRetail_price().multiply(new BigDecimal(goodsVO.getNumber()));
            CartVo cartVo = new CartVo();
            cartVo.setGoods_name(productInfo.getGoods_name());
            cartVo.setNumber(goodsVO.getNumber());
            cartVo.setRetail_price(productInfo.getRetail_price());
            cartVo.setList_pic_url(productInfo.getList_pic_url());
            cartVo.setGoods_specifition_ids(goodsVO.getGoodsSpecifitionIds());
            checkedGoodsList.add(cartVo);
        }
        BigDecimal couponPrice = new BigDecimal(0.0);
        if (couponId != null && couponId != 0 && (couponVo = this.apiCouponMapper.getUserCoupon(couponId)) != null) {
            couponPrice = couponVo.getType_money();
        }
        BigDecimal freightPrice = new BigDecimal(0.0);
        if (goodsTotalPrice.intValue() < 99) {
            freightPrice = new BigDecimal(10.0);
        }
        BigDecimal orderTotalPrice = goodsTotalPrice.add(freightPrice);
        BigDecimal actualPrice = orderTotalPrice.subtract(couponPrice);
        resultObj.put("freightPrice", freightPrice);
        resultObj.put("couponPrice", couponPrice);
        resultObj.put("checkedGoodsList", checkedGoodsList);
        resultObj.put("goodsTotalPrice", goodsTotalPrice);
        resultObj.put("orderTotalPrice", orderTotalPrice);
        resultObj.put("actualPrice", actualPrice);
        return this.toResponsSuccess(resultObj);
    }

    @ApiOperation(value="\u9009\u62e9\u4f18\u60e0\u5238\u5217\u8868")
    @PostMapping(value={"checkedCouponList"})
    public Object checkedCouponList(@LoginUser UserVo loginUser) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("user_id", loginUser.getUserId());
        List<CouponVo> couponVos = this.apiCouponService.queryUserCouponList(param);
        if (null != couponVos && couponVos.size() > 0) {
            Map cartData = (Map)this.getCart(loginUser);
            ArrayList<CartVo> checkedGoodsList = new ArrayList<CartVo>();
            ArrayList<Integer> checkedGoodsIds = new ArrayList<Integer>();
            for (CartVo cartEntity : (List)cartData.get("cartList")) {
                if (cartEntity.getChecked() != 1) continue;
                checkedGoodsList.add(cartEntity);
                checkedGoodsIds.add(cartEntity.getId());
            }
            BigDecimal goodsTotalPrice = (BigDecimal)((HashMap)cartData.get("cartTotal")).get("checkedGoodsAmount");
            for (CouponVo couponVo : couponVos) {
                if (couponVo.getMin_amount().compareTo(goodsTotalPrice) > 0) continue;
                couponVo.setEnabled(1);
            }
        }
        return this.toResponsSuccess(couponVos);
    }
}

