/*
 * Decompiled with CFR 0.152.
 */
package com.platform.api;

import com.platform.annotation.IgnoreAuth;
import com.platform.entity.BrandVo;
import com.platform.service.ApiBrandService;
import com.platform.util.ApiBaseAction;
import com.platform.util.ApiPageUtils;
import com.platform.utils.Query;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u54c1\u724c"})
@RestController
@RequestMapping(value={"/api/brand"})
public class ApiBrandController
extends ApiBaseAction {
    @Autowired
    private ApiBrandService brandService;

    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u54c1\u724c")
    @IgnoreAuth
    @PostMapping(value={"list"})
    public Object list(@RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="type", defaultValue="-1") Integer type, @RequestParam(value="name", defaultValue="") String name) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("fields", "id, name, floor_price, pic_url, app_list_pic_url, new_pic_url, type, scene_url");
        params.put("page", page);
        params.put("limit", size);
        params.put("sidx", "sort_order");
        params.put("order", "asc");
        if (type >= 0) {
            params.put("type", type);
        }
        if (!StringUtils.isEmpty((Object)name)) {
            params.put("name", name);
        }
        Query query = new Query(params);
        List<BrandVo> brandEntityList = this.brandService.queryList((Map<String, Object>)query);
        int total = this.brandService.queryTotal((Map<String, Object>)query);
        ApiPageUtils pageUtil = new ApiPageUtils(brandEntityList, total, query.getLimit(), query.getPage());
        return this.toResponsSuccess(pageUtil);
    }

    @ApiOperation(value="\u54c1\u724c\u8be6\u60c5")
    @IgnoreAuth
    @PostMapping(value={"detail"})
    public Object detail(@RequestParam Integer id) {
        HashMap<String, BrandVo> resultObj = new HashMap<String, BrandVo>();
        BrandVo entity = this.brandService.queryObject(id);
        resultObj.put("brand", entity);
        return this.toResponsSuccess(resultObj);
    }
}

