/*
 * Decompiled with CFR 0.152.
 */
package com.platform.api;

import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipaySystemOauthTokenRequest;
import com.alipay.api.request.AlipayUserInfoShareRequest;
import com.alipay.api.response.AlipaySystemOauthTokenResponse;
import com.alipay.api.response.AlipayUserInfoShareResponse;
import com.platform.annotation.IgnoreAuth;
import com.platform.entity.FullUserInfo;
import com.platform.entity.UserInfo;
import com.platform.entity.UserVo;
import com.platform.service.ApiUserService;
import com.platform.service.TokenService;
import com.platform.util.ApiBaseAction;
import com.platform.util.ApiUserUtils;
import com.platform.util.CommonUtil;
import com.platform.utils.CharUtil;
import com.platform.utils.R;
import com.platform.utils.ResourceUtil;
import com.platform.validator.Assert;
import com.qiniu.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"API\u767b\u5f55\u6388\u6743\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/api/auth"})
public class ApiAuthController
extends ApiBaseAction {
    private Logger logger = Logger.getLogger(this.getClass());
    @Autowired
    private ApiUserService userService;
    @Autowired
    private TokenService tokenService;

    @IgnoreAuth
    @PostMapping(value={"login"})
    @ApiOperation(value="\u767b\u5f55\u63a5\u53e3")
    public R login(String mobile, String password) {
        Assert.isBlank((String)mobile, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isBlank((String)password, (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        long userId = this.userService.login(mobile, password);
        Map<String, Object> map = this.tokenService.createToken(userId);
        return R.ok(map);
    }

    @ApiOperation(value="\u5fae\u4fe1\u767b\u5f55")
    @IgnoreAuth
    @PostMapping(value={"login_by_weixin"})
    public Object loginByWeixin() {
        JSONObject jsonParam = this.getJsonRequest();
        FullUserInfo fullUserInfo = null;
        String code = "";
        if (!StringUtils.isNullOrEmpty((String)jsonParam.getString("code"))) {
            code = jsonParam.getString("code");
        }
        if (null != jsonParam.get((Object)"userInfo")) {
            fullUserInfo = (FullUserInfo)jsonParam.getObject("userInfo", FullUserInfo.class);
        }
        if (null == fullUserInfo) {
            return this.toResponsFail("\u767b\u5f55\u5931\u8d25");
        }
        HashMap<String, Object> resultObj = new HashMap<String, Object>();
        UserInfo userInfo = fullUserInfo.getUserInfo();
        String requestUrl = ApiUserUtils.getWebAccess(code);
        this.logger.info((Object)("\u300b\u300b\u300b\u7ec4\u5408token\u4e3a\uff1a" + requestUrl));
        JSONObject sessionData = CommonUtil.httpsRequest(requestUrl, "GET", null);
        if (null == sessionData || StringUtils.isNullOrEmpty((String)sessionData.getString("openid"))) {
            return this.toResponsFail("\u767b\u5f55\u5931\u8d25");
        }
        String sha1 = CommonUtil.getSha1(fullUserInfo.getRawData() + sessionData.getString("session_key"));
        if (!fullUserInfo.getSignature().equals(sha1)) {
            return this.toResponsFail("\u767b\u5f55\u5931\u8d25");
        }
        Date nowTime = new Date();
        UserVo userVo = this.userService.queryByOpenId(sessionData.getString("openid"));
        if (null == userVo) {
            userVo = new UserVo();
            userVo.setUsername("\u5fae\u4fe1\u7528\u6237" + CharUtil.getRandomString((Integer)12));
            userVo.setPassword(sessionData.getString("openid"));
            userVo.setRegister_time(nowTime);
            userVo.setRegister_ip(this.getClientIp());
            userVo.setLast_login_ip(userVo.getRegister_ip());
            userVo.setLast_login_time(userVo.getRegister_time());
            userVo.setWeixin_openid(sessionData.getString("openid"));
            userVo.setAvatar(userInfo.getAvatarUrl());
            userVo.setGender(userInfo.getGender());
            userVo.setNickname(userInfo.getNickName());
            this.userService.save(userVo);
        } else {
            userVo.setLast_login_ip(this.getClientIp());
            userVo.setLast_login_time(nowTime);
            this.userService.update(userVo);
        }
        Map<String, Object> tokenMap = this.tokenService.createToken(userVo.getUserId());
        String token = MapUtils.getString(tokenMap, (Object)"token");
        if (null == userInfo || StringUtils.isNullOrEmpty((String)token)) {
            return this.toResponsFail("\u767b\u5f55\u5931\u8d25");
        }
        resultObj.put("token", token);
        resultObj.put("userInfo", userInfo);
        resultObj.put("userId", userVo.getUserId());
        return this.toResponsSuccess(resultObj);
    }

    @ApiOperation(value="\u652f\u4ed8\u5b9d\u767b\u5f55")
    @IgnoreAuth
    @PostMapping(value={"login_by_ali"})
    public Object login_by_ali() {
        JSONObject jsonParam = this.getJsonRequest();
        String code = "";
        if (!StringUtils.isNullOrEmpty((String)jsonParam.getString("code"))) {
            code = jsonParam.getString("code");
        }
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(ResourceUtil.getConfigByName((String)"ali.webAccessTokenhttps"), ResourceUtil.getConfigByName((String)"ali.appId"), ResourceUtil.getConfigByName((String)"ali.privateKey"), "json", "UTF-8", ResourceUtil.getConfigByName((String)"ali.pubKey"), "RSA2");
        AlipaySystemOauthTokenRequest request = new AlipaySystemOauthTokenRequest();
        request.setCode(code);
        request.setGrantType("authorization_code");
        try {
            AlipaySystemOauthTokenResponse oauthTokenResponse = (AlipaySystemOauthTokenResponse)alipayClient.execute((AlipayRequest)request);
            String accessToken = oauthTokenResponse.getAccessToken();
            AlipayUserInfoShareRequest userInfoShareRequest = new AlipayUserInfoShareRequest();
            AlipayUserInfoShareResponse userInfoResponse = (AlipayUserInfoShareResponse)alipayClient.execute((AlipayRequest)userInfoShareRequest, accessToken);
            Date nowTime = new Date();
            UserVo userVo = this.userService.queryByOpenId(userInfoResponse.getUserId());
            if (null == userVo) {
                userVo = new UserVo();
                userVo.setUsername("\u652f\u4ed8\u5b9d\u7528\u6237" + CharUtil.getRandomString((Integer)12));
                userVo.setPassword(userInfoResponse.getUserId());
                userVo.setRegister_time(nowTime);
                userVo.setRegister_ip(this.getClientIp());
                userVo.setLast_login_ip(userVo.getRegister_ip());
                userVo.setLast_login_time(nowTime);
                userVo.setWeixin_openid(userInfoResponse.getUserId());
                userVo.setAvatar(userInfoResponse.getAvatar());
                userVo.setGender("m".equalsIgnoreCase(userInfoResponse.getGender()) ? 1 : 0);
                userVo.setNickname(userInfoResponse.getNickName());
                this.userService.save(userVo);
            } else {
                userVo.setLast_login_ip(this.getClientIp());
                userVo.setLast_login_time(nowTime);
                this.userService.update(userVo);
            }
            Map<String, Object> tokenMap = this.tokenService.createToken(userVo.getUserId());
            String token = MapUtils.getString(tokenMap, (Object)"token");
            if (StringUtils.isNullOrEmpty((String)token)) {
                return this.toResponsFail("\u767b\u5f55\u5931\u8d25");
            }
            HashMap<String, Object> resultObj = new HashMap<String, Object>();
            resultObj.put("token", token);
            resultObj.put("userInfo", userInfoResponse);
            resultObj.put("userId", userVo.getUserId());
            return this.toResponsSuccess(resultObj);
        }
        catch (AlipayApiException e) {
            return this.toResponsFail("\u767b\u5f55\u5931\u8d25");
        }
    }
}

