/*
 * Decompiled with CFR 0.152.
 */
package com.platform.api;

import com.alibaba.fastjson.JSONObject;
import com.platform.annotation.LoginUser;
import com.platform.entity.AddressVo;
import com.platform.entity.UserVo;
import com.platform.service.ApiAddressService;
import com.platform.util.ApiBaseAction;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6536\u8d27\u5730\u5740"})
@RestController
@RequestMapping(value={"/api/address"})
public class ApiAddressController
extends ApiBaseAction {
    @Autowired
    private ApiAddressService addressService;

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7684\u6536\u8d27\u5730\u5740\u63a5\u53e3", response=Map.class)
    @PostMapping(value={"list"})
    public Object list(@LoginUser UserVo loginUser) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("user_id", loginUser.getUserId());
        List<AddressVo> addressEntities = this.addressService.queryList(param);
        return this.toResponsSuccess(addressEntities);
    }

    @ApiOperation(value="\u83b7\u53d6\u6536\u8d27\u5730\u5740\u7684\u8be6\u60c5", response=Map.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6536\u83b7\u5730\u5740ID", required=true, dataType="Integer")})
    @PostMapping(value={"detail"})
    public Object detail(Integer id, @LoginUser UserVo loginUser) {
        AddressVo entity = this.addressService.queryObject(id);
        if (entity == null) {
            return this.toResponsFail("\u5730\u5740\u9519\u8bef");
        }
        if (!entity.getUserId().equals(loginUser.getUserId())) {
            return this.toResponsObject(403, "\u60a8\u65e0\u6743\u67e5\u770b", "");
        }
        return this.toResponsSuccess(entity);
    }

    @ApiOperation(value="\u6dfb\u52a0\u6216\u66f4\u65b0\u6536\u8d27\u5730\u5740", response=Map.class)
    @PostMapping(value={"save"})
    public Object save(@LoginUser UserVo loginUser) {
        JSONObject addressJson = this.getJsonRequest();
        AddressVo entity = new AddressVo();
        if (null != addressJson) {
            String regex = "^[~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+]$";
            entity.setId(addressJson.getLong("id"));
            entity.setUserId(loginUser.getUserId());
            entity.setUserName(addressJson.getString("userName"));
            entity.setPostalCode(addressJson.getString("postalCode"));
            entity.setProvinceName(addressJson.getString("provinceName"));
            entity.setCityName(addressJson.getString("cityName"));
            entity.setCountyName(addressJson.getString("countyName"));
            entity.setDetailInfo(addressJson.getString("detailInfo"));
            entity.setNationalCode(addressJson.getString("nationalCode"));
            entity.setTelNumber(addressJson.getString("telNumber"));
            entity.setIs_default(addressJson.getInteger("is_default"));
            if (StringUtils.isEmpty((Object)entity.getUserName()) || entity.getUserName().length() < 2 || entity.getUserName().length() > 25 || entity.getUserName().matches(regex)) {
                return this.toResponsFail("\u6536\u8d27\u4eba\u540d\u5b57\u957f\u5ea6\u9700\u8981\u57282-25\u4e2a\u5b57\u7b26\u4e4b\u95f4\uff0c\u4e0d\u80fd\u5305\u542b\u975e\u6cd5\u5b57\u7b26\u3002");
            }
            if (StringUtils.isEmpty((Object)entity.getDetailInfo()) || entity.getDetailInfo().length() < 5 || entity.getDetailInfo().length() > 120 || entity.getDetailInfo().matches(regex)) {
                return this.toResponsFail("\u8be6\u7ec6\u5730\u5740\u957f\u5ea6\u9700\u8981\u57285-120\u4e2a\u5b57\u7b26\u4e4b\u95f4\uff0c\u4e0d\u80fd\u5305\u542b\u975e\u6cd5\u5b57\u7b26\u3002");
            }
            if (StringUtils.isEmpty((Object)entity.getTelNumber()) || entity.getTelNumber().length() > 40) {
                return this.toResponsFail("\u8bf7\u6b63\u786e\u586b\u5199\u53f7\u7801\u3002");
            }
        }
        if (entity.getIs_default() == 1) {
            AddressVo updateEntity = new AddressVo();
            updateEntity.setUserId(loginUser.getUserId());
            updateEntity.setIs_default(0);
            this.addressService.updateIsDefaultByUserId(updateEntity);
        }
        if (null == entity.getId() || entity.getId() == 0L) {
            entity.setId(null);
            this.addressService.save(entity);
        } else {
            this.addressService.update(entity);
        }
        return this.toResponsSuccess(entity);
    }

    public static void main(String[] args) {
        String nameRegex = "^[~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+]$";
        if (!"sdawe\u949f\u6587\uff0c".matches(nameRegex)) {
            System.out.println("\u6ee1\u8db3:" + "sdawe\u949f\u6587\uff0c".length());
            "sdawe\u949f\u6587\uff0c".length();
        } else {
            System.out.println("\u4e0d\u6ee1\u8db3");
        }
    }

    @ApiOperation(value="\u5220\u9664\u6307\u5b9a\u7684\u6536\u8d27\u5730\u5740", response=Map.class)
    @PostMapping(value={"delete"})
    public Object delete(@LoginUser UserVo loginUser) {
        JSONObject jsonParam = this.getJsonRequest();
        Integer id = jsonParam.getIntValue("id");
        AddressVo entity = this.addressService.queryObject(id);
        if (!entity.getUserId().equals(loginUser.getUserId())) {
            return this.toResponsObject(403, "\u60a8\u65e0\u6743\u5220\u9664", "");
        }
        this.addressService.delete(id);
        return this.toResponsSuccess("");
    }
}

